#ifndef MGLCanvas_Header
#define MGLCanvas_Header

#include "MRefCountedPtr.h"

namespace Aztec {

  class IMGLCanvas;
  typedef MRefCountedPtr<IMGLCanvas> IMGLCanvasPtr;

  class MGLCanvas;
  typedef MRefCountedPtr<MGLCanvas> MGLCanvasPtr;

}

#include <gui/MComponent.h>

namespace Aztec {


  /**
   * This is an open gl window class.
   */
  class AZTECGUI_EXPORT IMGLCanvas : public virtual IMComponent {
  protected:
    IMGLCanvas() { }
    ~IMGLCanvas() { }

  public:
    typedef IMGLCanvasPtr Ptr;

    typedef enum {
      GL_OK = 0,
        GL_CREATECONTEXT_FAILED = 1,
        GL_MAKECURRENT_FAILED = 2
    } GLErrorEnum;
    

  };


}


/**
 * The following header is included via the AZTEC_GUI
 * variable that should be defined for each platform
 * and used to specify an include directory
 * (ie. ../AztecGUICommon/include/gui/$(AZTEC_GUI)
 * when compiling this lib
 */
#include <MGLCanvasImpl.h>


#endif

