#ifndef MContainer_Header
#define MContainer_Header

#include "MRefCountedPtr.h"

namespace Aztec {

  class IMContainer;
  class MContainer;

  typedef MRefCountedPtr<IMContainer> IMContainerPtr;
  typedef MRefCountedPtr<MContainer> MContainerPtr;

}

#include <gui/MComponent.h>
#include <gui/MLayoutManager.h>
#include <gui/MPoint2D.h>
#include <gui/MSize2D.h>

#include <string>


namespace Aztec {

  class AZTECGUI_EXPORT IMContainer : public virtual IMComponent {
  protected:
    IMContainer() { }
    ~IMContainer() { }

  public:
    typedef IMContainerPtr Ptr;

    /**
     * Gets the number of components in this container.
     */
    virtual int getComponentCount() = 0;

    /**
     * Gets the given component.
     */
    virtual MComponentPtr getComponent(int index) = 0;

    /**
     * Adds the component to the container
     */
    virtual void addComponent(MComponentPtr component) = 0;

    /**
     * Adds the component to the container
     */
    virtual void addComponent(MComponentPtr component, int index) = 0;

    /**
     * Adds the component to the container
     */
    virtual void addComponent(MComponentPtr component, MConstraint constraints) = 0;

    /**
     * Adds the component to the container
     */
    virtual void addComponent(MComponentPtr component, int index, MConstraint constraints) = 0;


    /**
     * Removes the component from the container
     */
    virtual void removeComponent(int index) = 0;

    /**
     * Removes the given component from the container.
     */
    virtual void removeComponent(MComponentPtr component) = 0;

    /**
     * This gets the index of the given component. It 
     * returns -1 if the component is not a child of this container.
     */
    virtual int getComponentIndex(MComponentPtr component) = 0;

    /**
     * Sets the layout manager for the component
     */
    virtual void setLayoutManager(MLayoutManagerPtr layout) = 0;

    /**
     * Gets the layout manager used for this container.
     */
    virtual MLayoutManagerPtr getLayoutManager() = 0;

    /**
     * Performs the layout using the layout manager.
     */
    virtual void doLayout() = 0;

    /**
     * Gets the size of the client rect.
     */
    virtual MSize2D getClientSize() = 0;

    /**
     * called when a child component executes a command. This is called 
     * before the child's onCommand method. Returns true if it was handled. 
     * If false, the parent of the container will have its onCommand method 
     * called.
     */
    virtual bool onCommand(const std::string &command, const MComponentPtr &component) = 0;

  };

}


/**
 * The following header is included via the AZTEC_GUI
 * variable that should be defined for each platform
 * and used to specify an include directory
 * (ie. ../AztecGUICommon/include/gui/$(AZTEC_GUI)
 * when compiling this lib
 */
#include <MContainerImpl.h>



#endif

