#ifndef AztecGUI_PluginManager_Header
#define AztecGUI_PluginManager_Header

#include <AztecGUICommon.h>
#include <AztecGUIMParameterPlugin.h>

#include <MBaseObject.h>

#include <string>
#include <vector>

namespace AztecGUI {

  class AZTECGUI_EXPORT MPluginManager { 
  public:
    typedef std::vector<MParameterPluginPtr> ParameterPluginList;

    /**
     * This initlialises the Plugin Manager. This should be called by the host
     * application before any plugins are loaded.
     */
    static void initialise();

    /**
     * This cleans up any open dlls, and deletes any used memory. This should 
     * be called when the host application is exiting, and it is definately
     * known that all controls created by the various plugins have been 
     * clean up and destroyed properly.
     */
    static void cleanup();

    /**
     * This causes any plugins that match the given fileMask and exist
     * in the given directory to be loaded as GUI plugins. If the required
     * symbols are not export from each file, then that file is 
     * ignored.
     *
     * @param directory The directory to search
     * @param fileMask The mask to match filenames against.
     */
    static void loadPlugins(const std::string &directory, const std::string &fileMask);

    /**
     * This gets any Parameter plugins that are able to edit the given object.
     * The results are determined by iterating over all the known plugins,
     * and calling plugin->isUIForObject(object). Any that return true are
     * placed in the result list.
     *
     * @param object The object to get the UI plugins for.
     * @param result The list that the result is placed into. This is cleared
     *               at the start of the function.
     */
    static void getPluginsForObject(const Aztec::MBaseObjectPtr &object, ParameterPluginList &result);

  };

}

#endif