#include <Aztec3DPCH.h>
#include <views/Aztec3DView.h>

#include <tools/MSelectTool.h>

namespace AztecGUI {

  AztecGLCanvasPtr AztecGLView::getGLCanvasFor(const Aztec::MComponentPtr &component) {
    AztecGLViewPtr viewGL = AZTEC_CAST(AztecGLView, component);

    if (viewGL == NULL) {
      AztecGLCanvasPtr glCanvas = AZTEC_CAST(AztecGLCanvas, component);

      return glCanvas;
    }

    return viewGL->getCanvas();
  }


  AztecGLView::AztecGLView(const std::string &name)
    : AztecView(name) 
  {
  }

  MToolTypePtr AztecGLView::getSelectTool() {
    return new MSelectToolType();
  }

}

