#include <Aztec3DPCH.h>

#include <functions/edit/ObjectFunctions.h>

// Aztec2 includes
#include <views/AztecViewManager.h>
#include <views/DeletingView.h>

// AztecLib includes
#include <MScene.h>
#include <MSystemManager.h>
#include <MUIManager.h>
#include <MListsTrees.h>
#include <MEditableMesh.h>


namespace AztecGUI {

  /**
   * This takes the currently selected list of objects, and uses the most 
   * recently selected object as the new parent. It then makes all the other 
   * selected objects to be a child of that new parent object.
   */
  static int reparentSelection(const StringVector &args, std::string &result) {

    Aztec::MBaseObjectPtr Obj;
    Aztec::MBaseObjectPtr parentObj;
    Aztec::MBaseObjectListPtr SelList;
    
    SelList = Aztec::MScene::getGlobalScene()->getSelectedObjectList();
    
    // make sure we have two or more objects.
    if (SelList->getCount() < 2) {
      Aztec::MSystemManager::getInstance()->logOutput("Error: reparentSelection() requires at least two objects to be selected."); 
      return FunctionManager::FAIL;
    }

    parentObj = SelList->getTail();
    
    Aztec::MSceneObject *parent = AZTEC_CAST(Aztec::MSceneObject, parentObj);
    
    if (parent != NULL) {
      
      SelList->beginIteration();
      while ((Obj = SelList->getNext()) != NULL) {
        Aztec::MSceneObject *child = AZTEC_CAST(Aztec::MSceneObject, Obj);
        
        if (child != NULL && parent != NULL) {
          child->setParent(parent);
        }
      }
      SelList->endIteration();

      // deselect all the objects
      Aztec::MScene::getGlobalScene()->selectNone();
      
      // now select the new parent object.
      Aztec::MScene::getGlobalScene()->selectObject(parent);

      AztecViewManager::redrawAllViews();
    }

    return FunctionManager::SUCCEED;
    
  }

  void registerParentingFunctions(FunctionManager &man) {

    man.registerFunction("reparentSelection", reparentSelection);

  }


}

