
#ifndef Aztec2_Options_Window_Header
#define Aztec2_Options_Window_Header

#include <controls/CommandButton.h>

// AztecGUI includes
#include <gui/MWindow.h>
#include <gui/MLabel.h>
#include <gui/MTextField.h>
#include <gui/MHotKeyControl.h>


namespace AztecGUI {

  class OptionsWindow;
  typedef Aztec::MRefCountedPtr<OptionsWindow> OptionsWindowPtr;

  class OptionsWindow : public Aztec::MWindow {
  public:
    OptionsWindow(const std::string &title);
    bool onClose();
    virtual void onCreate();
    bool onCommand(const std::string &command, const Aztec::MComponentPtr &component);

    template <typename T>
    T* addField(const Aztec::MContainerPtr &container, const std::string &label, T *component) {
      container->addComponent(new Aztec::MLabel(label));
      container->addComponent(component);
      return component;
    }

    Aztec::MTextFieldPtr currentFriendly;
    Aztec::MTextFieldPtr currentCommand;
    Aztec::MHotKeyControlPtr currentShortcut;

    Aztec::MTextFieldPtr alreadyUsedCommand;

    static void show();
  };

}

#endif

