#include "StdAfx.h"
#include "WALTranslator.h"

#include <stdio.h>
#include <fcntl.h>
#include <sys/stat.h>

#include <IL/il.h>


#if defined( _DEBUG ) && defined( _MSC_VER )
// Memory leak detection for MS compiler
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif



MWALTranslator::MWALTranslator()
{
}

MWALTranslator::~MWALTranslator()
{
}


// Class related
MTranslatorPtr MWALTranslator::createNew() const {
   MWALTranslator   *NewTranslator;

   NewTranslator = new MWALTranslator;

   return NewTranslator;
}


bool MWALTranslator::canImportFile(MStr Filename)
{
   FILE  *hFile;
   bool  Result = true;

   Filename.Replace('/', '\\');
   hFile = fopen(Filename, "rb");

   if (!hFile) 
	   return false;

   fclose(hFile);

   return Result;
}


bool MWALTranslator::importFile(MStr Filename, MImagePtr Image)
{
   if (Image == NULL) return false;

   int      Width, Height;
   ILuint   Img;

   Filename.Replace('/', '\\');

   // Generate an image handle and load the requested image
   ilGenImages(1, &Img);
   ilBindImage(Img);

   if (!ilLoadImage((char*)(LPCTSTR)Filename))
   {
       ilDeleteImages(1, &Img);
       return false;
   }

   // Convert to 24 BPP
   ilConvertImage(IL_RGB, IL_UNSIGNED_BYTE);

   Width  = ilGetInteger(IL_IMAGE_WIDTH);
   Height = ilGetInteger(IL_IMAGE_HEIGHT);

   Image->setSize(Width, Height);

   memcpy(Image->getPixelData(), ilGetData(), (Width*Height) * sizeof(BYTE) * 3);

   // Delete the IL image handle
   ilDeleteImages(1, &Img);

   Image->flipVertical();

   return true;
}


bool MWALTranslator::exportFile(MStr Filename, MImagePtr Image)
{
   if (Image == NULL) return false;

   return false;
}
