#include "Stdafx.h"

#include "PrimPolyhedra.h"

#include "MBaseObject.h"
#include "MShapeObject.h"
#include "MMesh.h"
#include "MEditableMesh.h"

#include <params/MParameterFactory.h>

//----------------------------------------------------------------------------------------
//  MPolyhedra
//----------------------------------------------------------------------------------------
MPolyhedra::MPolyhedra() {
  addParameter(Aztec::MParameterFactory::createFloat("R", "Radius", "Radius"));
  addParameter(Aztec::MParameterFactory::createInteger("RDv", "RadDiv", "Divisions"));
  
  setParamByName("R", "10");
  setParamByName("RDv", "5");
  
  m_LastDX = 0;
  
  setFlag(OBJECTFLAG_NOCOMPONENTS);
  
  m_LastMesh = NULL;
  
}

MPolyhedra::~MPolyhedra()
{
  m_LastMesh = NULL;
}

Aztec::MBaseObjectPtr MPolyhedra::createNew() {
  MPolyhedra    *NewObj;
  
  NewObj = new MPolyhedra;
  
  NewObj->m_ParamList->setFromList(getParamList());
  
  return NewObj;
}

// MBaseObject methods
bool MPolyhedra::doUpdateObject() {
  MMeshCreator::doUpdateObject();
  
  m_ParamList->getParameter("Radius")->getValueFloat(m_Size);

  getOutputParameter()->setValue(convertToMesh());

  return true;
}

#include <math.h>


Aztec::MMeshPtr MPolyhedra::convertToMesh() {

  Aztec::MEditableMeshPtr mesh = new Aztec::MEditableMesh;
  float radius = 5.0;

  mesh->addVertex(0, 0, 0);
  mesh->addVertex(m_Size, 0, 0);
  mesh->addVertex(m_Size, m_Size, 0);
  mesh->addVertex(0, m_Size, 0);

  mesh->addTriangle(0, 1, 2);
  mesh->addTriangle(0, 2, 3);

  // now make a read only copy of this mesh.
  Aztec::MMeshPtr realMesh = new Aztec::MMesh(mesh);

  realMesh->calculateNormals();
  m_LastMesh = realMesh;
  
  return realMesh;
}

