#include "Stdafx.h"
#include <stdlib.h>


#include "PrimCylinder.h"
#include "MSystemManager.h"
#include <params/MParameterFactory.h>

#include "MEditableMesh.h"

#include <MMath.h>
#include <math.h>

#if defined( _DEBUG ) && defined( _MSC_VER )
// Memory leak detection for MS compiler
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

using namespace Aztec;

MCylinder::MCylinder()
{                                               
   addParameter(radius = MParameterFactory::createFloat("r", "radius", "Radius"));
   addParameter(height = MParameterFactory::createFloat("h", "height", "Height"));
   addParameter(radiusDiv = MParameterFactory::createInteger("rd", "radisDiv", "Radius Divisions"));
   addParameter(heightDiv = MParameterFactory::createInteger("hd", "heightDiv", "Height Divisions"));
   addParameter(capDiv = MParameterFactory::createInteger("cd", "capDiv", "Cap Divisions"));
   addParameter(capEnd = MParameterFactory::createBoolean("cap", "cap", "Cap Ends"));
   addParameter(joinCap = MParameterFactory::createBoolean("join", "join", "Join End Caps"));

   setParamByName("r", "10");
   setParamByName("h", "50");
   setParamByName("rd", "8");
   setParamByName("hd", "5");
   setParamByName("cd", "1");
   setParamByName("cap", "true");
   setParamByName("join", "true");

   setFlag(OBJECTFLAG_NOCOMPONENTS);

   m_LastMesh = NULL;

   lastRadius = 0;
   lastHeight = 0;
   lastCapDiv = 0;
   lastRadiusDiv = 0;
   lastHeightDiv = 0;
   lastCapEnd = -1;
   lastJoinCap = -1;

}

MCylinder::~MCylinder() {
}

/*
void MCylinder::onParameterChange(Aztec::MParameterObjectPtr param) {
  if (param == radius || 
      param == height || 
      param == capDiv || 
      param == radiusDiv || 
      param == heightDiv || 
      param == capEnd || 
      param == joinCap) 
  {
    if (radius->getValue() <= 0.0001) {
      radius->setValueFloat(0.0001);
    }
    m_LastMesh = NULL;
  }
}
*/

MBaseObjectPtr MCylinder::createNew() {
   MCylinder *NewObj;

   NewObj = new MCylinder;
   NewObj->m_ParamList->setFromList(getParamList());

   return NewObj;
}

bool MCylinder::doUpdateObject() {
  MMeshCreator::doUpdateObject();
  
  getOutputParameter()->setValue(convertToMesh());

  return true;
}


MMeshPtr MCylinder::convertToMesh() {

  if (m_LastMesh == NULL ||
      lastRadius != radius->getValue() ||
      lastHeight != height->getValue() ||
      lastCapDiv != capDiv->getValue() || 
      lastRadiusDiv != radiusDiv->getValue() ||
      lastHeightDiv != heightDiv->getValue() ||
      lastCapEnd != (capEnd->getValue() ? 1 : 0) ||
      lastJoinCap != (joinCap->getValue() ? 1: 0))
  {
    m_LastMesh = createMesh();

    lastRadius = radius->getValue();
    lastHeight = height->getValue();
    lastCapDiv = capDiv->getValue(); 
    lastRadiusDiv = radiusDiv->getValue();
    lastHeightDiv = heightDiv->getValue();
    lastCapEnd = (capEnd->getValue() ? 1 : 0);
    lastJoinCap = (joinCap->getValue() ? 1: 0);
  }

  return m_LastMesh;
}

#define VERT(row, column)  ( ( (row) * rowCount + (column) ) % vertexCount )

MMeshPtr MCylinder::createMesh() {


  MEditableMeshPtr mesh = new MEditableMesh(); 

  float angDiff = 360.0 / radiusDiv->getValue();
  float heightDiff = height->getValue() / heightDiv->getValue();
  int vertSegs = heightDiv->getValue();

  int columnCount = 0;
  int rowCount = vertSegs + 1;
  int vertexCount = 0;


  // make the vertices
  for (float ang = 0.0; ang < 360.0; ang += angDiff) {
    float x = radius->getValue() * cos(DegToRad(ang));
    float y = radius->getValue() * sin(DegToRad(ang));
    for (int i = 0; i <= vertSegs; ++i) {
      ++vertexCount;
      mesh->addVertex(x, y, heightDiff * i - height->getValue() / 2);
    }
    ++columnCount;
  }

  // now make the tris
  for (int i = 0; i < columnCount; ++i) {
    for (int j = 0; j < vertSegs; ++j) {
      int a = mesh->getNumTris();
      mesh->addTriangle(VERT(i, j), VERT(i+1, j), VERT(i, j+1));
      int b = mesh->getNumTris();
      mesh->addTriangle(VERT(i+1, j), VERT(i+1, j+1), VERT(i, j+1));

      mesh->unsetTriangleEdgeFlag(a, 1, EDGE_VISIBLE);
      mesh->unsetTriangleEdgeFlag(b, 2, EDGE_VISIBLE);
    }
  }

  if (capEnd->getValue()) {
    // create the fans on the top and bottom
    int topVert = mesh->getNumVerts();
    mesh->addVertex(0.0f, 0.0f, height->getValue() / 2);
    int bottomVert = mesh->getNumVerts();
    mesh->addVertex(0.0f, 0.0f, -height->getValue() / 2);

    for (int i = 0; i < columnCount; ++i) {
      mesh->addTriangle(VERT(i, 0), bottomVert, VERT(i+1, 0));
      mesh->addTriangle(VERT(i, vertSegs), VERT(i+1, vertSegs), topVert);
    }
  }

//  mesh->weldVertices(0, 0.0);
  
  return new MMesh(mesh);
}
