#ifndef Aztec_Primitive_Cylinder_Header
#define Aztec_Primitive_Cylinder_Header

#include <mesh/MMeshCreator.h>

#include <params/MFloatParameter.h>
#include <params/MIntParameter.h>
#include <params/MBooleanParameter.h>

class MCylinder : public Aztec::MMeshCreator {
protected:
  Aztec::MMeshPtr m_LastMesh;

  Aztec::MFloatParameterPtr radius, height;
  Aztec::MIntParameterPtr capDiv, radiusDiv, heightDiv;
  Aztec::MBooleanParameterPtr capEnd, joinCap;

  float lastRadius, lastHeight;
  int lastCapDiv, lastRadiusDiv, lastHeightDiv;
  int lastCapEnd, lastJoinCap;

public:
  // Construction/Destruction
  MCylinder();
  ~MCylinder();

  // MMeshCreator methods

  // MBaseObject methods
  MStr getClassName() { return MStr("Cylinder"); };
  Aztec::MBaseObjectPtr createNew();
  bool doUpdateObject();

protected:
  Aztec::MMeshPtr convertToMesh();

  Aztec::MMeshPtr createMesh();
};

#endif
 
