#ifndef PovrayRenderer_Header
#define PovrayRenderer_Header

#include <MSceneRenderer.h>
#include <MLight.h>
#include <MThread.h>

#include <stdio.h>
#include <string>

class PovrayRenderer;

class MRenderFinishedProc : public MThread {
public:
  MRenderFinishedProc(PovrayRenderer *param) 
    : renderer(param)
  {
  }

  // MThread methods
  void main();

private:
	PovrayRenderer *renderer;
};


class MRenderThreadProc : public MThread {
public:
	MRenderThreadProc(PovrayRenderer *param) 
    : renderer(param)
  {
  }

  // MThread methods
  void main();

private:
	PovrayRenderer *renderer;
	MRenderFinishedProc *renderFinishedProc;
};


typedef enum { Initialised, Started, Finished } RenderState;

class PovrayRenderer : public Aztec::MSceneRenderer {
protected:
  
public:
  PovrayRenderer();
  ~PovrayRenderer();
  
  std::string getTempFilename() {return tempFilename.c_str();}
  UpdateListenerPtr getCurrentListener() {return listener;}
  RenderState getCurrentState() {return currentState;}
  void setCurrentState(RenderState state) {currentState = state;}
#ifdef WIN32
  PROCESS_INFORMATION *getProcessInformation() {return &info;}
  STARTUPINFO *getStartUpInfo() {return &startInfo;}
#else
  // TODO: Create Linux equivalents
#endif
  

  // MSceneRenderer methods
  std::string getName();
  void initialise();
  bool start(const Aztec::MScenePtr &scene, 
             const Aztec::MParameterObjectListPtr &options, 
             const UpdateListenerPtr &listener);
  void stop();
  Aztec::MImagePtr getImage();
  Aztec::MParameterObjectListPtr getOptions();

private:
  std::string tempDirectory;
  std::string tempFilename;
  std::string iniFile;
  std::string povrayExecutable;
  UpdateListenerPtr listener;

  bool createRenderingThread();

  RenderState currentState;

#ifdef WIN32
  PROCESS_INFORMATION info;
  STARTUPINFO startInfo;
#else
  // TODO: Make a Linux equivalent
#endif

  friend class MRenderThreadProc;

  MRenderThreadProc *renderThreadProc;
};


#endif
