// ParticleVelocityEditDlg.cpp: implementation of the CParticleVelocityEditDlg class.
//
//////////////////////////////////////////////////////////////////////
#include "stdafx.h"
#include "resource.h"

#include "dialogs/ParticleVelocityEditDlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CParticleVelocityEditDlg::CParticleVelocityEditDlg() :
	x(0.0f), y(1.0f), z(0.0f)
{

}

CParticleVelocityEditDlg::~CParticleVelocityEditDlg()
{

}

void CParticleVelocityEditDlg::setBoxTitle(char *title)
{
	SetDlgItemText(IDC_VELOCITY_GROUP_BOX, title);
}

void CParticleVelocityEditDlg::setEntriesFromParams(int startIndex, particleParamType &params)
{
	int i = startIndex;

	x = params[i++];
	y = params[i++];
	z = params[i++];

	char buf[32];
	sprintf(buf, "%7.3f", x);
	SetDlgItemText(IDC_VELOCITY_X_EDIT, buf);
	sprintf(buf, "%7.3f", y);
	SetDlgItemText(IDC_VELOCITY_Y_EDIT, buf);
	sprintf(buf, "%7.3f", z);
	SetDlgItemText(IDC_VELOCITY_Z_EDIT, buf);
}

void CParticleVelocityEditDlg::getParamsFromEntries(particleParamType &params)
{
	char buf[32];
	GetDlgItemText(IDC_VELOCITY_X_EDIT, buf, sizeof(buf));
	params.push_back((float)atof(buf));
	GetDlgItemText(IDC_VELOCITY_Y_EDIT, buf, sizeof(buf));
	params.push_back((float)atof(buf));
	GetDlgItemText(IDC_VELOCITY_Z_EDIT, buf, sizeof(buf));
	params.push_back((float)atof(buf));
}

LRESULT CParticleVelocityEditDlg::OnInitDialog(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled)
{
	char buf[32];
	sprintf(buf, "%7.3f", x);
	SetDlgItemText(IDC_VELOCITY_X_EDIT, buf);
	sprintf(buf, "%7.3f", y);
	SetDlgItemText(IDC_VELOCITY_Y_EDIT, buf);
	sprintf(buf, "%7.3f", z);
	SetDlgItemText(IDC_VELOCITY_Z_EDIT, buf);

	return 0;
}

