#include <AztecMainPCH.h>
#include <tools/MGraphInsertKeyTool.h>

// AztecMain includes
#include <MDLGlobs.h>

#include <views/GraphViewWnd.h>

template <typename A, typename B> 
A round(A a, B b) {
  return (A)(b*(int)(a/(A)b + 0.5));
}

MGraphInsertKeyTool::MGraphInsertKeyTool() {
  setName("GraphInsertKeyTool");
  m_Dragging = false;
  m_RequiresSel = false;
}

static CGraphComponent* getGraph(MBaseViewWndPtr View) {
  CGraphComponent *graph = AZTEC_CAST(CGraphComponent, View);

  if (graph != NULL) {
    return graph;
  }

  // try and get our graph component
  CGraphViewWnd *graphView = AZTEC_CAST(CGraphViewWnd, View);
  if (graphView != NULL) {
    return graphView->getGraphComponent();
  }

  return NULL;
}

int MGraphInsertKeyTool::DrawTool(bool Select, MShiftState ShiftState, MBaseViewWndPtr View) {
  CGraphComponent *graph = getGraph(View);

  if (graph == NULL) {
    return 0;
  }

  if (m_Dragging) {
    float x1,y1,x2,y2;

    graph->clientToGraph(m_DownX, m_DownY, x1,y1);
    graph->clientToGraph(m_CurX, m_CurY, x2,y2);

    glColor3f(0.1f, 1.0f, 0.7f);
    glBegin(GL_LINE_LOOP);
    glVertex2f(x1,y1);
    glVertex2f(x2,y2);

    glEnd();
  }

  return 1;
}

int MGraphInsertKeyTool::onMouseDown(int mouseX, int mouseY, const MShiftState &Shift) {
  MToolType::onMouseDown(mouseX, mouseY, Shift);

  // restore our cursor so we can see what we are doing.
  ::SetCursor(::LoadCursor(NULL, IDC_ARROW));

  m_Dragging = true;
  m_CurX = m_DownX = mouseX;
  m_CurY = m_DownY = mouseY;

  CGraphComponent *graph = getGraph(g_CurView);

  if (graph == NULL) {
    return TOOLRESULT_DRAWNONE;
  }
  
  std::vector<CGraphComponent::ListKey> keys;
  std::vector<GraphPair> graphValues;

  graph->getGraphValues(graphValues);

  currentKeyList = NULL;

  // loop over all keys lists and store the values so we can revert 
  // back to them as needed.
  for (int i = 0; i < graphValues.size(); ++i) {
    MFloatKeyListPtr keyList = AZTEC_CAST(MFloatKeyList, graphValues[i].value);

    if (keyList == NULL) {
      continue;
    }

    keyList->storeValue();

    // loop over the keys and deselect them all.
    for (int i = 0; i < keyList->getKeyCount(); ++i) {
      MKeyPtr key = keyList->getKeyAtIndex(i);

      key->setSelected(false);
    }
  }

  currentKeyList = graph->getKeyListAtMouse(mouseX, mouseY);

  if (currentKeyList != NULL) {
    float x1,y1;
    
    graph->clientToGraph(m_DownX, m_DownY, x1, y1);
    
    int roundedTime = round(x1, currentKeyList->getGranularity());
    
    currentKeyList->setKey(
      currentKeyList->getValueAtTime(roundedTime),
      roundedTime);
  }

  return TOOLRESULT_DRAWALL;
}

int MGraphInsertKeyTool::onMouseUp(int mouseX, int mouseY, const MShiftState &Shift)
{
  MToolType::onMouseUp(mouseX, mouseY, Shift);

  CGraphComponent *graph = getGraph(g_CurView);

  if (graph == NULL) {
    return TOOLRESULT_DRAWNONE;
  }
  
  m_Dragging = false;

  m_UpX = mouseX;
  m_UpY = mouseY;

  currentKeyList = NULL;
  
  return TOOLRESULT_DRAWALL;
}

int MGraphInsertKeyTool::onMouseMove(int mouseX, int mouseY, const MShiftState &Shift)
{
  MToolType::onMouseMove(mouseX, mouseY, Shift);
  
  m_CurX = mouseX;
  m_CurY = mouseY;
  
  CGraphComponent *graph = getGraph(g_CurView);

  if (graph == NULL) {
    return TOOLRESULT_DRAWNONE;
  }

  if (m_Dragging && currentKeyList != NULL) {
    currentKeyList->restoreValue();

    float x1,y1;
    
    graph->clientToGraph(m_CurX, m_CurY, x1, y1);
    
    int roundedTime = round(x1, currentKeyList->getGranularity());
    
    currentKeyList->setKey(y1,roundedTime);

    return TOOLRESULT_DRAWALL;
  } else {

    // if we don't have a point selected, we just update the mouse cursor
    // to say we can insert a key.
    MFloatKeyListPtr list = graph->getKeyListAtMouse(mouseX, mouseY);

    HCURSOR cursor = ::LoadCursor(NULL, IDC_ARROW);

    if (list != NULL) {
      cursor = ::LoadCursor(NULL, IDC_SIZEALL);
    }
    ::SetCursor(cursor);
  } 
  
  return TOOLRESULT_DRAWNONE;
}


