// AztecMain.cpp : Defines the class behaviors for the application.
//

#include <AztecMainPCH.h>
#include "afxadv.h"

//#include "MdlGlobs.h"

#include "AztecMain.h"
#include "AztecMainDlg.h"

#include "Keyfuncs.h"
#include "MdlGlobs.h"
#include "MToolTipWnd.h"

#include "DlgGlobs.h"

#include <controls/AztecSplashScreen.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// Declare module used for managing ATL based windows
CComModule _Module;

/////////////////////////////////////////////////////////////////////////////
// CAztecMainApp

BEGIN_MESSAGE_MAP(CAztecMainApp, CWinApp)
	//{{AFX_MSG_MAP(CAztecMainApp)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG
	ON_COMMAND(ID_HELP, CWinApp::OnHelp)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAztecMainApp construction

CAztecMainApp::CAztecMainApp()
{
  m_pMainWnd = NULL;
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CAztecMainApp object

CAztecMainApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CAztecMainApp initialization

BOOL CAztecMainApp::InitInstance()
{
	// Initialize module used for ATL based activities
    _Module.Init(NULL, m_hInstance);

	AfxEnableControlContainer();

	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

#if _MFC_VER < 0x0007
// ARE: These calls are deprecated starting in MFC version 7
#ifdef _AFXDLL
	Enable3dControls();			// Call this when using MFC in a shared DLL
#else
	Enable3dControlsStatic();	// Call this when linking to MFC statically
#endif
#endif

   free((void*)m_pszRegistryKey);
   //Change the name of the registry key.
   //The CWinApp destructor will free the memory.
//m_pszRegistryKey=_tcsdup(_T("HKEY_CURRENT_USER\\Software\\MartinTools\\Modeller\\"));

	LoadStdProfileSettings(10);

	m_pMainWnd = new CAztecMainDlg();

  SetFormVars(m_pMainWnd);

 #if USE_SPACEBALL
	// Initialize spaceball (3DxWare) support.  TBD: What (if anything) needs to be
	// done if there isn't a spaceball?
	SiInitialize();
#endif

  // start the application loop
 AztecSplashScreen::createSplash();

	return TRUE;
}

BOOL CAztecMainApp::ExitInstance() {
  if (m_pMainWnd) {
    // Use the global main dialog variable to delete. If we use m_pMainWnd 
    // we get memory leaks ?!?!?!
    g_MainDlg->DestroyWindow();
    delete g_MainDlg;
    m_pMainWnd = NULL;
  }

#if USE_SPACEBALL
	// Close connection to the 3DxWare driver.
	SiTerminate();
#endif

	// Clean up ATL module
	_Module.Term();

  return TRUE;
}


void CAztecMainApp::UpdateMRUMenu(CCmdUI *pCmdUI)
{
}

BOOL CAztecMainApp::OnCmdMsg(UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo) 
{
   if (nID >= ID_FILE_MRU_FILE1 && nID <= ID_FILE_MRU_FILE5)
   {

      if (m_pMainWnd)
      {
         CMenu *Menu;
         
         Menu = m_pMainWnd->GetMenu();

         CString Str;
         Menu->GetMenuString(nID, Str, MF_BYCOMMAND);

//         if (nCode == -1)
//            KHelperOpenFile(Str);
         return TRUE;
      }
   }
   
	return CWinApp::OnCmdMsg(nID, nCode, pExtra, pHandlerInfo);
}

BOOL CAztecMainApp::PreTranslateMessage(MSG* pMsg) 
{
   if (pMsg->message == WM_MOUSEMOVE)
   {
      g_hMouseWnd = pMsg->hwnd;
      if (g_ToolTipWnd.GetMouseOverWnd() != pMsg->hwnd)
      {
         g_ToolTipWnd.DestroyToolTip();
         g_ToolTipWnd.SetMouseOverWnd(g_hMouseWnd);
      }
   }
   
	return CWinApp::PreTranslateMessage(pMsg);
}
