// ShelfDlg.cpp : implementation file
//

#include <AztecMainPCH.h>
#include "AztecMain.h"
#include "ShelfDlg.h"

#include <MTextFileStream.h>
#include "MdlGlobs.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CShelfDlg dialog


CShelfDlg::CShelfDlg(CWnd* pParent) : CDragScrollDlg(CShelfDlg::IDD, pParent)
{
  //{{AFX_DATA_INIT(CShelfDlg)
		// NOTE: the ClassWizard will add member initialization here
  //}}AFX_DATA_INIT
  
  m_Buttons = NULL;
  m_NumButtons = 0;
  m_LastCtrlID = 10000;
  m_VerticalScroll = false;
  m_HorizontalScroll = true;
}


void CShelfDlg::DoDataExchange(CDataExchange* pDX)
{
  CDialog::DoDataExchange(pDX);
  //{{AFX_DATA_MAP(CShelfDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
  //}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CShelfDlg, CDialog)
//{{AFX_MSG_MAP(CShelfDlg)
ON_WM_DESTROY()
//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CShelfDlg message handlers

BOOL CShelfDlg::PreTranslateMessage(MSG* pMsg) 
{
  if (pMsg->message == WM_KEYDOWN || pMsg->message == WM_KEYUP)
  {
    LONG  WndStyle;
    
    WndStyle = GetWindowLong(pMsg->hwnd, GWL_STYLE);
    if (WndStyle & ES_AUTOHSCROLL)
    {
      // we have an edit box
      if (pMsg->message == WM_KEYDOWN)
      {
        if (pMsg->wParam == VK_ESCAPE || pMsg->wParam == VK_RETURN)
        {
          GetParentOwner()->SetFocus();
          return 1;
        }
      }
    }
    else
      return GetParentOwner()->PostMessage(pMsg->message, pMsg->wParam, pMsg->lParam);
  }
  
  // Call CWnd::PreTranslate message so we do not get the special dialog message handling
  //	return CWnd::PreTranslateMessage(pMsg);
  
  return CDragScrollDlg::PreTranslateMessage(pMsg);
}

void CShelfDlg::OnDestroy() 
{
  // go an delete the buttons
  {
    int      n;
    
    for (n=0; n < m_NumButtons; n++)
    {
      if (m_Buttons[n])
      {
        m_Buttons[n]->DestroyWindow();
        delete m_Buttons[n];
        m_Buttons[n] = NULL;
      }
    }
    if (m_Buttons)
      delete[] m_Buttons;
    
    m_Buttons = NULL;
    m_NumButtons = 0;
  }
  
  
  CDialog::OnDestroy();
}

int CShelfDlg::AddButton(const MStr &ActionName, const MStr &ButtonImage, const MStr &toolGroup)
{
  CImageButton   *But;
  RECT           Rect;
  
  Rect.left = m_NumButtons * 34;
  Rect.top = 1;
  Rect.bottom = m_NumButtons*32 + 32;
  Rect.bottom = 33;
  But = new CImageButton(ActionName, toolGroup);
  
  But->Create("But", BS_PUSHLIKE | BS_CHECKBOX, Rect, this, m_LastCtrlID);
  m_LastCtrlID++;
  
  // if SetImage fails, try a relative path
  if (But->SetImage(ButtonImage) == 0)
  {
    if (But->SetImage(g_ProgSet.m_PrefsPath + ButtonImage) == 0)
    {
      g_SysMan->logOutput("Warning: Could not load image '%s' for button '%s'", (LPCTSTR)ButtonImage, (LPCTSTR)ActionName);
    }
  }
  
  But->ShowWindow(SW_SHOW);
  
  {
    CImageButton   **NewButList;
    int            n;
    
    NewButList = new CImageButton*[m_NumButtons+1];
    for (n = 0; n < m_NumButtons; n++)
    {
      NewButList[n] = m_Buttons[n];
    }
    NewButList[m_NumButtons] = But;
    
    if (m_Buttons)
      delete[] m_Buttons;
    m_Buttons = NewButList;
  }
  
  
  m_NumButtons++;
  return m_NumButtons;
}

int CShelfDlg::SaveToFile(const MStr &Filename)
{
  MTextFileWriter File;
  char     Name[128];
  MStr     Str;
  int      n;
  
  if (Filename.GetLength() > 0)
  {
    m_ShelfFilename = Filename;
  }
  
  if (!File.open(m_ShelfFilename)) {
    return 0;
  }
  
  GetWindowText(Name, 128);     // Get the name of the current tab
  if (strlen(Name) == 0) {
    strcpy(Name, "Untitled");
  }
  
  File.writeString(Name);
  File.writeString("\n");
  
  for (n = 0; n< m_NumButtons; n++)
  {
    File.writeString(m_Buttons[n]->GetActionName());
    File.writeString(", ");
    File.writeString(m_Buttons[n]->GetImageFilename());
    File.writeString("\n");
  }
  
  File.close();
  
  return 1;
}

int CShelfDlg::LoadFromFile(const MStr &Filename)
{
  MTextFileReader File;
  MStr ShelfName;
  
  m_ShelfFilename = Filename;
  if (!File.open(m_ShelfFilename)) {
    return 0;
  }
  
  // read in the entire file
  ShelfName = File.readLine();
  SetWindowText((LPCTSTR)ShelfName);
  
  while (!File.isAtEOF()) {
    MStr lineStr = File.readLine();
    if (lineStr.GetLength() == 0) {
      continue;
    }
    std::string line = lineStr.c_str();
    
    int commaIndex = line.find(',');

    std::string commandName;
    std::string imageFilename;
    std::string toolGroup;

    commandName = line.substr(0, commaIndex);

    if (commaIndex != std::string::npos) {
      int start = commaIndex + 1;
      while (line[start] == ' ' && start < line.length()) ++start;
      commaIndex = line.find(',', start);
      imageFilename = line.substr(start, commaIndex-start);

      if (commaIndex != std::string::npos) {
        start = commaIndex + 1;
        while (line[start] == ' ' && start < line.length()) ++start;
        commaIndex = line.find(',', start);
        toolGroup = line.substr(start, commaIndex-start);
      }
    }

    AddButton(commandName.c_str(), imageFilename.c_str(), toolGroup.c_str());
    
  }
  
  File.close();
  
  return 1;
}
