// TimeScroller.cpp : implementation file
//

#include <AztecMainPCH.h>
#include <controls/MMenuBar.h>

#include <views/BaseViewWnd.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

static const int TEXT_MARGIN_WIDTH = 6;
static const int TEXT_MARGIN_HEIGHT = 4;

static const int MB_POPUPMENU = WM_USER + 1101;

// These values were taken from WinUser.h from the august 2002 Platform SDK.
// note the wrapping #ifndef .. #endif were added manually.
#ifndef COLOR_MENUHILIGHT
#define COLOR_MENUHILIGHT       29
#endif
#ifndef COLOR_MENUBAR
#define COLOR_MENUBAR           30
#endif
#ifndef SPI_GETFLATMENU
#define SPI_GETFLATMENU                     0x1022
#endif



MMenuBar::MMenuBar(bool menuBar) {
  name = "main";
  hilightedMenu = -1;
  itemHeight = 24;
  openingMenus = false;
  constantSize = false;
  lastRowCount = 1;
  hilight3D = true;
  centreText = true;
  isMenuBar = menuBar;
  useXPColours = false;

  if (isMenuBar) {
    constantSize = false;
    hilight3D = true;
    centreText = true;
  } else {
    constantSize = true;
    hilight3D = false;
    centreText = false;
  }

  // find out if we are using windows xp, and if we are, enable a check
  // for using flat menus
  OSVERSIONINFO version;
  version.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
  ::GetVersionEx(&version);

  if ((version.dwMajorVersion = 5 && version.dwMinorVersion > 1) ||
    version.dwMajorVersion > 5) 
  {
    useXPColours = true;
    BOOL flat = FALSE;
    SystemParametersInfo(SPI_GETFLATMENU, 0, &flat, 0);
    hilight3D = !flat;
  }
}

MMenuBar::~MMenuBar() {
  for (int i = 0; i < items.size(); ++i) {
    delete items[i];
  }
}

void MMenuBar::addMenu(const std::string &name, HMENU menu, int index) {
  if (index == -1) {
    items.push_back(new MenuItem(name, menu));
  } else {
    items.insert(items.begin() + index, new MenuItem(name, menu));
  }
}

void MMenuBar::addMenu(const std::string &name, MenuCreator *creator, int index) {
  if (index == -1) {
    items.push_back(new MenuItem(name, creator));
  } else {
    items.insert(items.begin() + index, new MenuItem(name, creator));
  }
}

int MMenuBar::getMenuHeight() {
  return (itemHeight + 2) * lastRowCount + 1;
}

void MMenuBar::setCommonSize(bool commonSize) {
  constantSize = commonSize;
}


BEGIN_MESSAGE_MAP(MMenuBar, CWnd)
//{{AFX_MSG_MAP(MMenuBar)
ON_WM_PAINT()
ON_WM_SIZE()
ON_WM_DESTROY()
ON_MESSAGE(MB_POPUPMENU, OnPopupMenu)
//}}AFX_MSG_MAP
END_MESSAGE_MAP()


LRESULT MMenuBar::OnPopupMenu(WPARAM wParam, LPARAM lParam)
{
  setHilightedMenu(wParam);
/*	if(m_nPressed<0)
		m_nPressed = m_nItemCount - 1;
	if(m_nPressed >= m_nItemCount)
		m_nPressed = 0;*/
//	TrackPopup();

	return 0;
}


static void draw3dRect(HDC dc, const RECT &rect, bool sunken = false) {
  HPEN hPen, hOldPen;
  COLORREF lightColour = ::GetSysColor(COLOR_3DHILIGHT);
  COLORREF darkColour = ::GetSysColor(COLOR_3DSHADOW);
  COLORREF topLeftColour = sunken ? darkColour : lightColour;
  COLORREF bottomRightColour = sunken ? lightColour : darkColour;

  hPen = ::CreatePen(PS_SOLID, 1, topLeftColour);
  hOldPen = (HPEN)::SelectObject(dc, hPen);
  ::MoveToEx(dc, rect.right, rect.top, NULL);
  ::LineTo(dc, rect.left, rect.top);
  ::LineTo(dc, rect.left, rect.bottom);
  ::SelectObject(dc, hOldPen);
  ::DeleteObject(hPen);
  
  hPen = ::CreatePen(PS_SOLID, 1, bottomRightColour);
  hOldPen = (HPEN)::SelectObject(dc, hPen);
  ::MoveToEx(dc, rect.right, rect.top, NULL);
  ::LineTo(dc, rect.right, rect.bottom);
  ::LineTo(dc, rect.left, rect.bottom);
  ::SelectObject(dc, hOldPen);
  ::DeleteObject(hPen);
}

void MMenuBar::OnPaint() {
  CPaintDC    Paintdc(this); // device context for painting
  
  HDC         dc;
  HBITMAP     bitmap, oldBitmap;

  RECT        ClientRect;
  HFONT       hOldFont;
  
  GetClientRect(&ClientRect);
  
  dc = ::CreateCompatibleDC(Paintdc.m_hDC);
  bitmap = ::CreateCompatibleBitmap(Paintdc.m_hDC, ClientRect.right, ClientRect.bottom);
  oldBitmap = (HBITMAP)::SelectObject(dc, bitmap);
  
  hOldFont = (HFONT)::SelectObject(dc, GetStockObject(DEFAULT_GUI_FONT));
  
  HBRUSH menuBackground = ::GetSysColorBrush(COLOR_MENUBAR);

  // If that failed, just use the standard 3d colour.
  if (menuBackground == NULL) {
    menuBackground = ::GetSysColorBrush(COLOR_MENU);
  }
  if (menuBackground == NULL) {
    menuBackground = ::GetSysColorBrush(COLOR_3DFACE);
  }
  // fill in the menu bar
  ::FillRect(dc, &ClientRect, menuBackground);
  
  // draw the menu items.
  drawMenuItems(dc);

  // revert the dc back to its original state.
  ::SelectObject(dc, hOldFont);

  // copy the bitmap to the screen dc
  GetClientRect(&ClientRect);

  ::BitBlt(Paintdc.m_hDC, 0,0,ClientRect.right, ClientRect.bottom, dc, 0,0,SRCCOPY);

  ::SelectObject(dc, oldBitmap);
  ::DeleteObject(bitmap);
  ::DeleteDC(dc);
}

void MMenuBar::OnSize( UINT nType, int cx, int cy ) {
  layoutItems();
}

void MMenuBar::OnDestroy() {
  showMenu(-1);
}


void MMenuBar::drawMenuItems(HDC dc) {

  layoutItems(dc);

  HFONT oldFont, menuFont;

  SetBkMode(dc, TRANSPARENT);

  // TODO: get the actual menu font instead of the default one
  menuFont = (HFONT)::GetStockObject(DEFAULT_GUI_FONT);
  oldFont = (HFONT)::SelectObject(dc, menuFont);

  ::SetTextColor(dc, ::GetSysColor(COLOR_MENUTEXT));
  for (int index = 0; index < items.size(); ++index) {
    if (!hilight3D) {
      // if the item is the selected one, draw a coloured in box behind it
      if (hilightedMenu == index) {
        HBRUSH brush = ::CreateSolidBrush(::GetSysColor(useXPColours ? COLOR_MENUHILIGHT : COLOR_HIGHLIGHT));
        ::FillRect(dc, &items[index]->rect, brush);
        ::DeleteObject(brush);

        ::SetTextColor(dc, ::GetSysColor(COLOR_HIGHLIGHTTEXT));
      } else {
        ::SetTextColor(dc, ::GetSysColor(COLOR_MENUTEXT));
      }
    }

    DWORD flags;
    RECT rect = items[index]->rect;
    if (centreText) {
      flags = DT_SINGLELINE | DT_CENTER | DT_VCENTER;
    } else {
      flags = DT_SINGLELINE | DT_VCENTER;
      rect.left += TEXT_MARGIN_WIDTH;
    }

    ::DrawText(dc, items[index]->caption.c_str(), items[index]->caption.length(), &rect, flags);
  }

  if (hilight3D) {
    if (hilightedMenu != -1) {
      RECT border = items[hilightedMenu]->rect;
      draw3dRect(dc, border, openingMenus);
    }
  }

  ::SelectObject(dc, oldFont);

}

void MMenuBar::setHilightedMenu(int index, int changeOpeningMenu) {
  bool newOpenMenuValue = openingMenus;
  if (changeOpeningMenu == 0) {
    newOpenMenuValue = false;
  } else if (changeOpeningMenu == 1) {
    newOpenMenuValue = true;
  }

  if (hilightedMenu != index || openingMenus != newOpenMenuValue) {
    openingMenus = newOpenMenuValue;

    if (!(openingMenus && index == -1)) {
      hilightedMenu = index;
      ::InvalidateRect(m_hWnd, NULL, FALSE);


      // if we are in open menu mode, we have to open its popup menu
      if (openingMenus && index != -1) {
        showMenu(index);
      } else {
        showMenu(-1);
      }
    }
  }


}

////////////////////////////////////////////////////////////////////////////////
MMenuBar*		g_pMenuBar	= NULL;
HHOOK			g_hMsgHook	= NULL;
////////////////////////////////////////////////////////////////////////////////
//	The hook, used to process message when menu is visible
LRESULT CALLBACK MenuInputFilter(int nCode, WPARAM wParam, LPARAM lParam)
{
	MSG* pMsg = (MSG*)lParam;

	if(!g_pMenuBar || nCode != MSGF_MENU)
		return CallNextHookEx(g_hMsgHook,nCode,wParam,lParam);
	if(g_pMenuBar->onMenuInput(pMsg))
		return TRUE;
	else
		return CallNextHookEx(g_hMsgHook,nCode,wParam,lParam);
}

BOOL MMenuBar::onMenuInput(MSG* pMsg)
{
	BOOL bResult = FALSE;

	switch(pMsg->message)
	{
	case WM_MOUSEMOVE:
		{
			POINT pt;
			pt.x = LOWORD(pMsg->lParam);
			pt.y = HIWORD(pMsg->lParam);
			ScreenToClient(&pt);
/*			if(m_ptMouse.x == pt.x && m_ptMouse.y == pt.y)
				return TRUE;
		
			m_ptMouse.x = pt.x;
			m_ptMouse.y = pt.y;*/

			int nTest = getItemFromPos(pt.x, pt.y);

			if(nTest >= 0 && nTest < items.size() && nTest != hilightedMenu)
			{
//				PressButton(m_nPressed,FALSE);
				SendMessage(WM_CANCELMODE,0,0);
				PostMessage(MB_POPUPMENU,nTest,1);
				bResult = TRUE;
			}
		}
		break;
	case WM_LBUTTONDOWN:
		{
			POINT pt;
			pt.x = LOWORD(pMsg->lParam);
			pt.y = HIWORD(pMsg->lParam);
			ScreenToClient(&pt);

			int nTest = getItemFromPos(pt.x, pt.y);

			if(nTest<0)
        setHilightedMenu(-1, false);
			else if(nTest == hilightedMenu)
			{
        setHilightedMenu(-1, false);
				PostMessage(WM_CANCELMODE,0,0);
				bResult = TRUE;
			}
		}
		break;
	case WM_KEYDOWN:
		{
			TCHAR vkey = pMsg->wParam;
			if(vkey == VK_LEFT)
			{
//				PressButton(m_nPressed,FALSE);
//				m_nPressed --;
				PostMessage(WM_CANCELMODE,0,0);
				PostMessage(MB_POPUPMENU,(hilightedMenu + items.size() + 1) % items.size(),1);
				bResult = TRUE;
			}
			else if(vkey == VK_RIGHT)
			{
//				PressButton(m_nPressed,FALSE);
//				m_nPressed ++;
				PostMessage(WM_CANCELMODE,0,0);
				PostMessage(MB_POPUPMENU,(hilightedMenu + 1) % items.size(),1);
				bResult = TRUE;
			}
			else if (vkey == VK_ESCAPE)
			{
				PostMessage(WM_CANCELMODE,0,0);
        setHilightedMenu(-1, false);
				bResult = TRUE;
			}
		}
		break;
	case WM_MENUSELECT:
		GetOwner()->SendMessage(WM_MENUSELECT, pMsg->wParam, pMsg->lParam);
		bResult = TRUE;
		break;
	default:
		break;
	}

	return bResult;
}


void MMenuBar::showMenu(int index) {
  
  if (index >= 0) {
    RECT menuRect;
    
    if (isMenuBar) {
      menuRect.left = items[index]->rect.left;
      menuRect.top = items[index]->rect.bottom + 1;
    } else {
      menuRect.left = items[index]->rect.right;
      menuRect.top = items[index]->rect.top - 1;
    }

    menuRect.right = menuRect.left + 50;
    menuRect.bottom = menuRect.top + 50;

    ClientToScreen(&menuRect);

    HMENU currentMenu = items[index]->getMenu();

	  //Install the hook
	  g_pMenuBar = this;
	  g_hMsgHook = SetWindowsHookEx(WH_MSGFILTER,
			  MenuInputFilter, NULL, GetCurrentThreadId());

    // Show the menu
    BOOL result = TrackPopupMenuEx(
                      currentMenu,
                      TPM_LEFTALIGN | TPM_LEFTBUTTON | TPM_RIGHTBUTTON | TPM_VERTICAL, 
                      menuRect.left, 
                      menuRect.top, 
                      m_hWnd, 
                      NULL);

    DWORD err = 0;
    if (result == FALSE) {
      err = ::GetLastError();
    }

    // Uninstall the hook
	  UnhookWindowsHookEx(g_hMsgHook);

	  g_hMsgHook = NULL;
	  g_pMenuBar = NULL;

    items[index]->finishedWithMenu(currentMenu);
  
  }
  
}

int MMenuBar::getLargestWidth(HDC dc) {
  layoutItems(dc);

  int largestWidth = 0;
  for (ItemVector::iterator it = items.begin(); it != items.end(); ++it) {
    if ((*it)->width > largestWidth) {
      largestWidth = (*it)->width;
    }
  }

  return largestWidth;
}

void MMenuBar::calcItemSizes(HDC dc) {
  bool needToReleaseDC = false;
  if (dc == NULL) {
    dc = ::GetDC(m_hWnd);
    needToReleaseDC = true;
  }

  HFONT oldFont, menuFont;

  // TODO: get the actual menu font instead of the default one
  menuFont = (HFONT)::GetStockObject(DEFAULT_GUI_FONT);
  oldFont = (HFONT)::SelectObject(dc, menuFont);

  int largestWidth = 0;
  itemHeight = 0;
  for (ItemVector::iterator it = items.begin(); it != items.end(); ++it) {
    SIZE size;
    ::GetTextExtentPoint(dc, (*it)->caption.c_str(), (*it)->caption.length(), &size);

    size.cx += TEXT_MARGIN_WIDTH * 2;
    size.cy += TEXT_MARGIN_HEIGHT;

    (*it)->width = size.cx;
    (*it)->height = size.cy;

    if (size.cy > itemHeight) {
      itemHeight = size.cy;
    }

    if (size.cx > largestWidth) {
      largestWidth = size.cx;
    }
  }

  // if we want all our menu items to be of a constant size, then we go over
  // them and reassign the size.
  if (constantSize) {
    for (ItemVector::iterator it = items.begin(); it != items.end(); ++it) {
      (*it)->width = largestWidth;
    }    
  }

  // restore the old font for the dc
  ::SelectObject(dc, oldFont);

  if (needToReleaseDC) {
    ::ReleaseDC(m_hWnd, dc);
  }
}


void MMenuBar::layoutItems(HDC dc) {
  calcItemSizes(dc);

  RECT clientRect;
  RECT itemRect;

  GetClientRect(&clientRect);

  // give the menu bar a border
  clientRect.left += 1;
  clientRect.right -= 1;
  clientRect.top += 1;
  clientRect.bottom -= 1;

  itemRect.left = clientRect.left;
  itemRect.top = clientRect.top;

  int rowCount = 1;
  for (ItemVector::iterator it = items.begin(); it != items.end(); ++it) {

    itemRect.right = itemRect.left + (*it)->width;
    itemRect.bottom = itemRect.top + (*it)->height;

    // if we extend beyond the edge of the window, then we should wrap around.
    if (itemRect.right > clientRect.right) {
      itemRect.right += clientRect.left - itemRect.left;
      itemRect.left = clientRect.left;
      itemRect.top += itemHeight + 1;
      itemRect.bottom += itemHeight + 1;
      ++rowCount;
    }

    (*it)->rect = itemRect;

    itemRect.left = itemRect.right + 1;
  }

  if (lastRowCount != rowCount) {
    lastRowCount = rowCount;
    RECT windowRect;
    ::GetWindowRect(m_hWnd, &windowRect);
    int width = windowRect.right - windowRect.left;
    ::SetWindowPos(m_hWnd, NULL, windowRect.left, windowRect.top, width, getMenuHeight(), SWP_NOZORDER | SWP_NOMOVE);
  }
}

int MMenuBar::getItemFromPos(int x, int y) {
  for (int index = 0; index < items.size(); ++index) {
    if (x >= items[index]->rect.left &&
        x <= items[index]->rect.right &&
        y >= items[index]->rect.top && 
        y <= items[index]->rect.bottom) 
    {
      return index;
    }
  }

  return -1;
}

LRESULT MMenuBar::WindowProc(UINT message, WPARAM wParam, LPARAM lParam) 
{
  // if we received any mouse messages, pass it on to our parent as well,
  // so view switching and things work.
  switch (message) {
  case WM_LBUTTONDOWN:
  case WM_MBUTTONDOWN:
  case WM_RBUTTONDOWN:
  case WM_LBUTTONUP:
  case WM_MBUTTONUP:
  case WM_RBUTTONUP:
    setCurrentViewForControl(this);
  }

  if (message == WM_LBUTTONDOWN) {
    // check to see if we have clicked on a menu item, if we have, then
    // we switch to the mode where we open menus up.
    int xPos = LOWORD(lParam);  // horizontal position of cursor 
    int yPos = HIWORD(lParam);  // vertical position of cursor 
    int index = getItemFromPos(xPos, yPos);

    setHilightedMenu(index, true);

//    return 1;
  }
  if (message == WM_LBUTTONUP) {
    int xPos = LOWORD(lParam);  // horizontal position of cursor 
    int yPos = HIWORD(lParam);  // vertical position of cursor 
    int index = getItemFromPos(xPos, yPos);

    setHilightedMenu(index, false);
  } 

  if (message == WM_MOUSEMOVE) {
    int xPos = LOWORD(lParam);  // horizontal position of cursor 
    int yPos = HIWORD(lParam);  // vertical position of cursor 
    int index = getItemFromPos(xPos, yPos);

    setHilightedMenu(index);
  }
  if (message == WM_ERASEBKGND) {
    return 1;
  }
  
  return CWnd::WindowProc(message, wParam, lParam);
}


BOOL MMenuBar::OnCommand( WPARAM wParam, LPARAM lParam ) {
  // Since we are just a menu bar, send the command message onto our parent.
  GetParent()->SendMessage(WM_COMMAND, wParam, lParam);
  return TRUE;
}

MMenuBar::MenuItem::MenuItem(const std::string &text, HMENU newMenu) {
  caption = text;
  menu = newMenu;
  creator = NULL;
}

MMenuBar::MenuItem::MenuItem(const std::string &text, MenuCreator *menuCreator) {
  caption = text;
  creator = menuCreator;
  menu = NULL;
  
}

MMenuBar::MenuItem::MenuItem(const MenuItem &src) {
  caption = src.caption;
  creator = src.creator;
  menu = src.menu;
  
}

MMenuBar::MenuItem::~MenuItem() {
  if (creator != NULL) {
    delete creator;
  }
  if (menu != NULL) {
    ::DestroyMenu(menu);
  }
}

HMENU MMenuBar::MenuItem::getMenu() {
  if (menu != NULL) {
    return menu;
  } else if (creator != NULL) {
    return creator->createMenu();
  } else {
    return NULL;
  }
}

void MMenuBar::MenuItem::finishedWithMenu(HMENU menu) {
  if (creator != NULL) {
    creator->destroyMenu(menu);
  }
}


// Popup menu class used for creating popup menus
MMenuBar::PopupMenu::PopupMenu(DWORD resource) {
  menuResource = resource;
  parentMenu = NULL;
}
HMENU MMenuBar::PopupMenu::createMenu() {
  parentMenu = ::LoadMenu(AfxGetApp()->m_hInstance, MAKEINTRESOURCE(menuResource));
  HMENU popup = ::GetSubMenu(parentMenu, 0);

  return popup;
}

void MMenuBar::PopupMenu::destroyMenu(HMENU menu) {
  ::DestroyMenu(parentMenu);
  parentMenu = NULL;
}




