// ControlConfig.cpp : implementation file
//

#include <AztecMainPCH.h>
#include "AztecMain.h"
#include "ControlConfig.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CControlConfig property page

IMPLEMENT_DYNCREATE(CControlConfig, CPropertyPage)

CControlConfig::CControlConfig() : CPropertyPage(CControlConfig::IDD)
{
	//{{AFX_DATA_INIT(CControlConfig)
	//}}AFX_DATA_INIT

   m_LastShift = NULL;
}

CControlConfig::~CControlConfig()
{
}

void CControlConfig::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CControlConfig)
	DDX_Control(pDX, IDC_SHIFTCHECK, m_ShiftCheck);
	DDX_Control(pDX, IDC_RIGHTCHECK, m_RightCheck);
	DDX_Control(pDX, IDC_MIDDLECHECK, m_MiddleCheck);
	DDX_Control(pDX, IDC_LEFTCHECK, m_LeftCheck);
	DDX_Control(pDX, IDC_CTRLCHECK, m_CtrlCheck);
	DDX_Control(pDX, IDC_ALTCHECK, m_AltCheck);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CControlConfig, CPropertyPage)
	//{{AFX_MSG_MAP(CControlConfig)
	ON_LBN_SELCHANGE(IDC_CONTROLLIST, OnSelchangeControllist)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CControlConfig message handlers

BOOL CControlConfig::OnInitDialog() 
{
	CPropertyPage::OnInitDialog();
	
   CListBox    *ListBox;

   ListBox = (CListBox*)GetDlgItem(IDC_CONTROLLIST);
   if (ListBox)
   {
      int      Index;

      ListBox->ResetContent();
      Index = ListBox->AddString("Orbit View");
      ListBox->SetItemDataPtr(Index, &m_PanOrbitKey);
      Index = ListBox->AddString("Pan View");
      ListBox->SetItemDataPtr(Index, &m_PanTrackKey);
      Index = ListBox->AddString("Zoom View");
      ListBox->SetItemDataPtr(Index, &m_PanZoomKey);
      Index = ListBox->AddString("Grab Manipulator");
      ListBox->SetItemDataPtr(Index, &m_ManipGrabKey);

      ListBox->SelectString(0, "Orbit View");
   }
   OnSelchangeControllist();

   
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CControlConfig::OnSelchangeControllist() 
{
   // Update the changes on the old shift state
   if (m_LastShift)
   {
      m_LastShift->m_Left = (m_LeftCheck.GetCheck() != 0) ;
      m_LastShift->m_Mid = (m_MiddleCheck.GetCheck() != 0) ;
      m_LastShift->m_Right = (m_RightCheck.GetCheck() != 0) ;
      m_LastShift->m_Ctrl = (m_CtrlCheck.GetCheck() != 0) ;
      m_LastShift->m_Shift = (m_ShiftCheck.GetCheck() != 0) ;
      m_LastShift->m_Alt = (m_AltCheck.GetCheck() != 0) ;
   }

   CListBox    *ListBox;

   ListBox = (CListBox*)GetDlgItem(IDC_CONTROLLIST);

   if (!ListBox)
      return;

   int            Index;
   MShiftState    *ShiftKey;

   Index = ListBox->GetCurSel();
   ShiftKey = (MShiftState*)ListBox->GetItemDataPtr(Index);

   if (!ShiftKey)
      return;
   
   m_LeftCheck.SetCheck(ShiftKey->m_Left);
   m_MiddleCheck.SetCheck(ShiftKey->m_Mid);
   m_RightCheck.SetCheck(ShiftKey->m_Right);
   m_CtrlCheck.SetCheck(ShiftKey->m_Ctrl);
   m_ShiftCheck.SetCheck(ShiftKey->m_Shift);
   m_AltCheck.SetCheck(ShiftKey->m_Alt);

   m_LastShift = ShiftKey;
}

void CControlConfig::OnOK() 
{
   OnSelchangeControllist();
	
	CPropertyPage::OnOK();
}
