// ConDlg.cpp : implementation file
//

#include <AztecMainPCH.h>
#include "AztecMain.h"
#include "ConDlg.h"
#include "MDLGlobs.h"

#include "HelperFuncs.h"

#include <locale>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CConsoleDlg dialog


CConsoleDlg::CConsoleDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CConsoleDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CConsoleDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT

  currentCmdIndex = -1;
  splitPos = 50;
  splitBarWidth = 4;
  minInputHeight = 50;
  minOutputHeight = 50;
}

BOOL CConsoleDlg::PreTranslateMessage(MSG* pMsg) {
  if (pMsg->message == WM_KEYDOWN) {
    MShiftState shift;

    shift.SetFromKeyState();

	  // See if user hit enter key and a control key.
	  if (pMsg->wParam == VK_RETURN && 
       (shift.m_Ctrl || ((pMsg->lParam & 0x01000000) != 0)) ) {
      submitEditContents();
      return TRUE;
    }
    if (pMsg->wParam == VK_UP && shift.m_Ctrl) {
      if (currentCmdIndex + 1 < (int)commandHistory.size()) {
        currentCmdIndex++;
        m_InputEdit.SetWindowText(commandHistory[currentCmdIndex].c_str());
      }
    }
    if (pMsg->wParam == VK_DOWN && shift.m_Ctrl) {
      if (currentCmdIndex > 0) {
        currentCmdIndex--;
        m_InputEdit.SetWindowText(commandHistory[currentCmdIndex].c_str());
      }
    }
  }

	// Call CWnd::PreTranslate message so we do not get the special dialog message handling
  return CDialog::PreTranslateMessage(pMsg);
}

void CConsoleDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CConsoleDlg)
	DDX_Control(pDX, IDC_OUTPUTEDIT, m_OutputEdit);
	DDX_Control(pDX, IDC_INPUTEDIT, m_InputEdit);
	DDX_Control(pDX, IDC_EXECUTEBUT, m_ExecBut);
	//}}AFX_DATA_MAP
}


void CConsoleDlg::submitEditContents() {
  // Grab the text from the edit control
  char *buf = new char[m_InputEdit.GetWindowTextLength() + 1];
  std::string result;

  m_InputEdit.GetWindowText(buf, m_InputEdit.GetWindowTextLength() + 1);
  m_InputEdit.SetWindowText("");

  MSystemManager::getInstance()->getLogger()->writeString("\n\n");

  AddLineToConsole(buf);

  std::string evalStr;
  if (MScriptInterpreter::getInstance()->ExecuteScript(buf, evalStr)) {
    if (evalStr.length() > 0) {
      MSystemManager::getInstance()->getLogger()->writeString(evalStr.c_str());
    } else {
    }
  } else {
    // Failed to evaluate - need to produce an error message
  }

  delete[] buf;

}

BEGIN_MESSAGE_MAP(CConsoleDlg, CDialog)
	//{{AFX_MSG_MAP(CConsoleDlg)
	ON_WM_WINDOWPOSCHANGED()
	ON_WM_KEYDOWN()
  ON_WM_CLOSE()
  ON_WM_ACTIVATE()
  ON_WM_GETMINMAXINFO()
  ON_WM_MOUSEMOVE()
  ON_WM_LBUTTONDOWN()
  ON_WM_LBUTTONUP()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CConsoleDlg message handlers


void CConsoleDlg::OnWindowPosChanged(WINDOWPOS FAR* lpwndpos) 
{
	CDialog::OnWindowPosChanged(lpwndpos);
  resizeControls();
}

void CConsoleDlg::resizeControls(bool adjustSplitPos) {	
   RECT  WndClientRect, InputRect, OutputRect, ButtonRect;

   GetClientRect(&WndClientRect);
   m_InputEdit.GetWindowRect(&InputRect);
   m_OutputEdit.GetWindowRect(&OutputRect);
   m_ExecBut.GetWindowRect(&ButtonRect);

   m_InputEdit.ScreenToClient(&InputRect);
   m_OutputEdit.ScreenToClient(&OutputRect);
   m_ExecBut.ScreenToClient(&ButtonRect);

   int inputWidth = WndClientRect.right - splitBarWidth - ButtonRect.right;
   int outputHeight = WndClientRect.bottom - splitPos - splitBarWidth;

   if (outputHeight < minOutputHeight) {
     outputHeight = minOutputHeight;
     if (adjustSplitPos) {
       splitPos = WndClientRect.bottom - outputHeight - splitBarWidth;
     }
   }

   int inputHeight = WndClientRect.bottom - outputHeight - splitBarWidth;

   if (inputHeight < minInputHeight) {
     inputHeight = minInputHeight;
     outputHeight = WndClientRect.bottom - splitBarWidth - inputHeight;

     if (adjustSplitPos) {
       splitPos = WndClientRect.bottom - outputHeight - splitBarWidth;
     }
   }

   if (outputHeight < minOutputHeight) {
     outputHeight = minOutputHeight;
   }
   if (inputHeight < minInputHeight) {
     inputHeight = minInputHeight;
   }

   m_InputEdit.MoveWindow(
     1,
     outputHeight + splitBarWidth / 2 , 
     inputWidth, 
     inputHeight);

   m_ExecBut.MoveWindow(
     inputWidth + 2, outputHeight + splitBarWidth / 2,
     WndClientRect.right - inputWidth - splitBarWidth, 
     inputHeight);

   m_OutputEdit.MoveWindow(
     1,
     1 , 
     WndClientRect.right-2, 
     outputHeight - splitBarWidth);

}

void CConsoleDlg::OnGetMinMaxInfo( MINMAXINFO FAR* lpMMI ) {
  RECT rect;

  rect.left = 0; 
  rect.top = 0;
  rect.right = lpMMI->ptMinTrackSize.x;
  rect.bottom = minInputHeight + minOutputHeight + splitBarWidth;

  AdjustWindowRect(&rect, GetStyle(), FALSE);

  lpMMI->ptMinTrackSize.y = rect.bottom - rect.top;
}

void CConsoleDlg::OnLButtonDown( UINT nFlags, CPoint point ) {
  // resize the controls, and update our split position to make sure it is
  // set up properly.
  resizeControls(true);
  SetCapture();
}

void CConsoleDlg::OnMouseMove( UINT nFlags, CPoint point ) {

  if (nFlags & MK_LBUTTON) {
    splitPos += lastY - point.y;
    resizeControls();
  }

  lastX = point.x;
  lastY = point.y;
}

void CConsoleDlg::OnLButtonUp( UINT nFlags, CPoint point ) {
  ReleaseCapture();

  // resize the controls, and update our split position to make sure it is
  // set up properly.
  resizeControls(true);
}


void CConsoleDlg::AddLineToConsole(const char *Text)
{
  MSystemManager::getInstance()->getLogger()->writeString(Text);
  MSystemManager::getInstance()->getLogger()->writeString("\n");

  MStr str;

  std::string text = Text;

  int startIndex;
  int endIndex;

  for (startIndex = 0; startIndex < text.length(); ++startIndex) {
    if (!std::isspace(text[startIndex], std::locale())) {
      break;
    }
  }

  for (endIndex = text.length() - 1; endIndex >= 0; --endIndex) {
    if (!std::isspace(text[endIndex], std::locale())) {
      break;
    }
  }

  text = text.substr(startIndex, endIndex - startIndex + 1);

  // attempt to find this text in the commandHistory.

  CommandList::iterator it;

  for (it = commandHistory.begin(); it != commandHistory.end(); ++it) {
    // if we have a match, then we should move the command to the 
    // front of the command list.
    if (*it == text) {
      commandHistory.erase(it);
      break;
    }
  }
  commandHistory.insert(commandHistory.begin(), text);
  currentCmdIndex = -1;

}

void CConsoleDlg::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
  MShiftState shift;

  shift.SetFromKeyState();

	// See if user hit enter key and a control key.
	if (nChar == VK_RETURN && shift.m_Ctrl) {
    submitEditContents();
	} else {
		CDialog::OnKeyDown(nChar, nRepCnt, nFlags);
	}
}

void CConsoleDlg::OnClose() {
  ShowWindow(FALSE);
}

void CConsoleDlg::OnActivate( UINT nState, CWnd* pWndOther, BOOL bMinimized ) {
  m_InputEdit.SetFocus();
}
