//
// ColorWheel.cpp : implementation file
//

#include <AztecMainPCH.h>
#include "resource.h"
#include "ColorWheel.h"

#include "DlgGlobs.h"
#include "MdlMsgs.h"

#include <math.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


const double pi = 3.141592654;


/////////////////////////////////////////////////////////////////////////////
// CColorWheel

CColorWheel::CColorWheel() :
m_Buffer(NULL),
m_Bitmap(NULL),
m_Drag(false),
m_Pos(0)
{
}

CColorWheel::~CColorWheel()
{
    if (NULL != m_Buffer) { m_Buffer->DeleteDC(); delete m_Buffer; }
    if (NULL != m_Bitmap) { m_Bitmap->DeleteObject(); delete m_Bitmap; }
}


BEGIN_MESSAGE_MAP(CColorWheel, CStatic)
//{{AFX_MSG_MAP(CColorWheel)
ON_WM_PAINT()
ON_WM_NCHITTEST()
ON_WM_LBUTTONDOWN()
ON_WM_MOUSEMOVE()
ON_WM_ERASEBKGND()
ON_WM_LBUTTONUP()
//}}AFX_MSG_MAP
END_MESSAGE_MAP()



/////////////////////////////////////////////////////////////////////////////
// CColorWheel message handlers

void CColorWheel::OnPaint() 
{
    CPaintDC dc(this);
    
    // Copy backbuffer to the front
    dc.BitBlt(0,0,m_rc.Width(),m_rc.Height(),m_Buffer,0,0,SRCCOPY);
/*    ::TransparentBlt(dc.m_hDC,
        0, 0, m_rc.Width(), m_rc.Height(),
        m_Buffer->m_hDC,
        0, 0, m_rc.Width(), m_rc.Height(),
        RGB(0,0,0));*/
    
    // Do not call CStatic::OnPaint() for painting messages
}

UINT CColorWheel::OnNcHitTest(CPoint point) 
{
    // Return HTCLIENT so that we can get mouse messages from this control
    return HTCLIENT;
}

void CColorWheel::CreateBuffer() 
{
    CClientDC   dc(this);
    
    GetClientRect(&m_rc);
    
    if (NULL == m_Bitmap)
    {
        m_Bitmap = new CBitmap();
        m_Bitmap->CreateCompatibleBitmap(&dc, m_rc.Width(), m_rc.Height());
    }
    
    if (NULL == m_Buffer)
    {
        m_Buffer = new CDC();
        m_Buffer->CreateCompatibleDC(&dc);
        m_Buffer->SelectObject(m_Bitmap);
    }
}

void CColorWheel::PreSubclassWindow() 
{
    // TODO: Add your specialized code here and/or call the base class
    CStatic::PreSubclassWindow();
    
    // Do some initialization
    CreateBuffer();
    PaintWheel();
}


UCHAR RGB2(float rm1, float rm2, float rh)
{
  if      (rh > 360.0f) rh -= 360.0f;
  else if (rh <   0.0f) rh += 360.0f;
 
  if      (rh <  60.0f) rm1 = rm1 + (rm2 - rm1) * rh / 60.0f;   
  else if (rh < 180.0f) rm1 = rm2;
  else if (rh < 240.0f) rm1 = rm1 + (rm2 - rm1) * (240.0f - rh) / 60.0f;      
                   
  return UCHAR(rm1 * 255);
}

DWORD HSL2RGB(float Hue, float Sat, float Lum)
{
    DWORD   Col;

    if (Sat == 0.0)
    {
        Col = RGB(UCHAR(Lum * 255.0), UCHAR(Lum * 255.0), UCHAR(Lum * 255.0));
    }
    else
    {
        float   rm1, rm2;

        if (Lum <= 0.5f) rm2 = Lum + Lum * Sat;
        else rm2 = Lum + Sat - Lum * Sat;

        rm1 = 2.f * Lum - rm2;   

        Col = RGB(RGB2(rm1, rm2, Hue + 120.0f), RGB2(rm1, rm2, Hue), RGB2(rm1, rm2, Hue - 120.0f));
    }

    return Col;
}

/*MVector3 RGB2HSL(int Red, int Green, int Blue)
{
    // TODO
}*/

void CColorWheel::PaintWheel()
{
    if (m_Buffer && m_Bitmap)
    {
        CPoint  p1, p2;
        CRect   rc;
        CRgn    rgn;
        CBrush  brush;
        int     hue = 0, i;
        
        // Set background color to black (for transparency)
        //m_Buffer->FillSolidRect(m_rc, RGB(0,0,0));
        m_Buffer->FillSolidRect(m_rc, ::GetSysColor(COLOR_BTNFACE));
        
        // Starting point for drawing the wheel (0 degrees)
        p1.x = m_rc.left;
        p1.y = m_rc.bottom/2;
        
        // Don't use a pen for drawing the wheel
        m_Buffer->SelectStockObject(NULL_PEN);
        
        for (i=360; i--;)
        {
            hue++;
            if (hue > 360) hue -= 360;

            // Create a new starting point
            p2.x = int((m_rc.right / 2)  - cos(pi * i / 180.0) * 90.0);
            p2.y = int((m_rc.bottom / 2) - sin(pi * i / 180.0) * 90.0);
            
            brush.CreateSolidBrush(HSL2RGB(hue,/*var sat*/200/200.f,/*var lum*/100/200.f));
            CBrush*  old = m_Buffer->SelectObject(&brush);

            m_Buffer->Pie(m_rc, p1, p2);

            m_Buffer->SelectObject(&old);
            brush.DeleteObject();

            p1 = p2;
        }
        
        
        // Paint all other places black (will be transparent)
        p1.x = m_rc.left;
        p1.y = m_rc.bottom/2;
        
        rc.SetRect(m_rc.left+20,m_rc.top+20, m_rc.right-20,m_rc.bottom-20);
        
        rgn.CreateEllipticRgnIndirect(&rc);
        //brush.CreateSolidBrush(RGB(0,0,0));
        brush.CreateSolidBrush(::GetSysColor(COLOR_BTNFACE));
        
        m_Buffer->FillRgn(&rgn, &brush);
        
        rgn.DeleteObject();
        brush.DeleteObject();
        
        
        // RVE> TODO: Fill the rectangle with colors (HSL)
        m_Buffer->FillSolidRect(m_rc.left+40+2, m_rc.top+40+1, m_rc.right-80-4, m_rc.bottom-80-4, RGB(88,87,104));

        CFont   font;
        CFont*  oldfont;

        font.CreateFont(10, 0, 0, 0, 10, FALSE, FALSE, FALSE, ANSI_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY, DEFAULT_PITCH, "MS Sans Serif");
        oldfont = m_Buffer->SelectObject(&font);

        m_Buffer->TextOut(m_rc.left+52,m_rc.bottom/2-10,CString("work in progress"));
        m_Buffer->SelectObject(&oldfont);

        font.DeleteObject();
    }
    
    PaintBullet();
}

void CColorWheel::OnMouseMove(UINT nFlags, CPoint point) 
{
    if (m_Drag)
    {
        CPoint  pt;
        
        pt.x = m_rc.right/2;
        pt.y = m_rc.bottom/2;
        
        m_ctPos.x = pt.x + (/*Radius*/82) * sin(m_Pos * pi / 180.0);
        m_ctPos.y = pt.y - (/*Radius*/82) * cos(m_Pos * pi / 180.0);
        
        SetPosition(point);
        m_Color = m_Buffer->GetPixel(m_ctPos);
        SendMessageToParent(0);
    }
    
    CStatic::OnMouseMove(nFlags, point);
}

void CColorWheel::OnLButtonDown(UINT nFlags, CPoint point) 
{
    if (!m_Drag)
    {
        // Capture the mouse
        m_Drag = true;
        SetCapture();
        SetFocus();

        CPoint  pt;
        
        pt.x = m_rc.right/2;
        pt.y = m_rc.bottom/2;
        
        m_ctPos.x = pt.x + (/*Radius*/82) * sin(m_Pos * pi / 180.0);
        m_ctPos.y = pt.y - (/*Radius*/82) * cos(m_Pos * pi / 180.0);

        SetPosition(point);
        m_Color = m_Buffer->GetPixel(m_ctPos);
        SendMessageToParent(0);
    }
}

void CColorWheel::OnLButtonUp(UINT nFlags, CPoint point) 
{
    if (m_Drag)
    {
        // Release the mouse
        m_Drag = false;
        ReleaseCapture();
        
        CPoint  pt;
        
        pt.x = m_rc.right/2;
        pt.y = m_rc.bottom/2;
        
        m_ctPos.x = pt.x + (/*Radius*/82) * sin(m_Pos * pi / 180.0);
        m_ctPos.y = pt.y - (/*Radius*/82) * cos(m_Pos * pi / 180.0);

        SetPosition(point);
        m_Color = m_Buffer->GetPixel(m_ctPos);
        SendMessageToParent(0);
    }
}

BOOL CColorWheel::OnEraseBkgnd(CDC* pDC) 
{
    // Don't.. just don't do it
    return true;
}

void CColorWheel::SetPosition(CPoint pt)
{
    CPoint  ptCenter;
    double  newPos = 0.0;
    
    ptCenter.x = m_rc.right/2;
    ptCenter.y = m_rc.bottom/2;
    
    CSize szDelta = pt - ptCenter;
    
    if (szDelta.cx != 0) newPos = 90.0 - atan(-(double)szDelta.cy / (double)szDelta.cx) * 180.0 / pi;
    if (((szDelta.cx == 0) && (szDelta.cy >= 0)) || (szDelta.cx < 0)) newPos += 180.0;
    
    while (newPos < 0.0)    newPos += 360.0;
    while (newPos >= 360.0) newPos -= 360.0;
    
    m_Pos = newPos;
}

void CColorWheel::PaintBullet()
{
    CClientDC dc(this);
    int       radius = 5;

    // Copy backbuffer to the front
    dc.BitBlt(0,0,m_rc.Width(),m_rc.Height(),m_Buffer,0,0,SRCCOPY);
/*    ::TransparentBlt(dc.m_hDC,
                     0, 0, m_rc.Width(), m_rc.Height(),
                     m_Buffer->m_hDC,
                     0, 0, m_rc.Width(), m_rc.Height(),
                     RGB(0,0,0));*/

    // Draw the bullet
    CPen pen(PS_SOLID,3, RGB(0,0,0));
    CPen* oldPen = dc.SelectObject(&pen);

    dc.Arc(m_ctPos.x-radius, m_ctPos.y-radius,
           m_ctPos.x+radius, m_ctPos.y+radius,
           m_ctPos.x-radius, m_ctPos.y-radius,
           m_ctPos.x-radius, m_ctPos.y-radius);

    dc.SelectObject(oldPen);
}

void CColorWheel::SendMessageToParent(int Message)
{
    CWnd* pWnd = GetParent();

    if (pWnd)
    {
        pWnd->PostMessage(WM_COMMAND, (WPARAM)(WM_USER+1));
    }
}

void CColorWheel::SetColor(int Red, int Green, int Blue)
{
    m_Color = RGB(Red, Green, Blue);
}
