#ifndef ImageViewerView_Header
#define ImageViewerView_Header

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <params/MKeyParameter.h>
#include <params/MVector3KeyParameter.h>

#include "BaseViewWnd.h"
#include "BaseOpenGLWnd.h"
#include <controls/MMenuBar.h>
#include <controls/ImageViewer.h>
#include <views/MZoomableWindow.h>

#include <map>

class ImageViewerView : public MBaseViewWnd
{
// Construction
public:
  ImageViewerView();
  
  ImageViewer* getImageComponent();

  // MBaseViewWnd methods
  void ViewCreate();
  void DrawView();
  
  DWORD ViewPopupMenu(int x, int y);
  int HandlePopupCommand(DWORD Cmd);

  // MBaseObject methods
  MStr getClassName() {return MStr("ImageViewerView");};
  MStr getParentClassName() {return MStr("MBaseViewWnd");};
  MBaseObjectPtr createNew();

private:
  HDC paintDC;
  ImageViewer *imageViewer;

  int openImage();
  int saveImage();

public:
  // Overrides
  // ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(ImageViewerView)
  virtual BOOL OnCommand( WPARAM wParam, LPARAM lParam );
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~ImageViewerView();

	// Generated message map functions
protected:
	//{{AFX_MSG(ImageViewerView)
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnClose();
	afx_msg void OnPaint();
  afx_msg void OnDestroy();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_TRACKVIEWWND_H__49925471_455F_11D3_9A66_0040332C7B2F__INCLUDED_)
