#ifndef BASEOPENGLWND_H
#define BASEOPENGLWND_H


#define DRAWAXIS_X         0x0001
#define DRAWAXIS_Y         0x0002
#define DRAWAXIS_Z         0x0004
#define DRAWAXIS_W         0x0008
#define DRAWAXIS_ALLAXES   0x000F
#define DRAWAXIS_XGRAY     0x0010
#define DRAWAXIS_YGRAY     0x0020
#define DRAWAXIS_ZGRAY     0x0040
#define DRAWAXIS_WGRAY     0x0080
#define DRAWAXIS_ALLGRAY   0x00F0
#define DRAWAXIS_LABELS    0x0100
#define DRAWAXIS_ARROWS    0x0200

#define DRAWAXIS_MIDDLE_NORMAL_X 0x1000
#define DRAWAXIS_MIDDLE_NORMAL_Y 0x2000
#define DRAWAXIS_MIDDLE_NORMAL_Z 0x3000

#define DRAWAXIS_MIDDLE_TYPE  0x7000

#define DRAWAXIS_NORMAL    0x010F

#include <gl/gl.h>

#include "ModelTypes.h"
#include "MMath.h"
#include "BaseViewWnd.h"
#include <controls/GLCanvas.h>

class MBaseOpenGLWnd;

typedef MRefCountedPtr<MBaseOpenGLWnd> MBaseOpenGLWndPtr;

// Bare bones class just to handle construction, maintenence and destruction of opengl windwos.
class MBaseOpenGLWnd : public MBaseViewWnd {
public:
  MBaseOpenGLWnd();
  virtual ~MBaseOpenGLWnd();
  
  double         m_ModelMat[16], m_ProjMat[16];
  int            m_ViewInfo[4];
  Matrix3        m_ViewXForm, m_ViewXFormInv;
  
  RECT           m_WindowRect;
  float          m_GateLeft, m_GateTop, m_GateBottom, m_GateRight, m_Aspect;
  int            m_GLDownX, m_GLDownY, m_GLUpX, m_GLUpY;
  GLCanvas *glCanvas;

  bool needToCreateFonts;
  
  int InitOpenGL(HWND hWnd);
  int KillOpenGL();
  int GLMakeCurrent();
  int GLResizeToClient();
  int GLSwapBuffers();
  void DrawView();

  void createFonts(DWORD fontStart);
  
  virtual void AdjustProjectionMatrix(MSelectMethod PickMode = smNone, 
                                      int left = -1, int top = -1,
                                      int right = -1, int bottom = -1);
  virtual void DoViewportTransform();
  virtual void UpdateXFormMatricies();
  virtual void AdjustScaleFactor();
  virtual float GetScaleFactor();
  float GetViewAspect();
  
  MVector3 ScreenToWorldSpace(int X, int Y, const MPlane &ConstrainPlane);
  MRay GetViewRay(int X, int Y);

  MVector3 getViewNormal();
  
  /**
   * Draws anything in the view that goes on top of everything else, eg View Labels
   * or anything that is drawn in screen space
   */
  virtual void DrawViewExtras();

  /**
   * Draws the given text at the given location.
   */
  static void GLDrawText(float x, float y, const MStr &str);

  /**
   * Draws the given text, but limits it to the given number of characters
   * by adding in an ellipses if it goes beyond the extents given.
   */
  void GLDrawText(float x, float y, int maxWidth, const MStr &str);
  /**
   * Draws the standard RGB axis icon using the given attributes. If 
   * ArrowHeads == true, arrow heads are placed on the end of the three 
   * lines, and a Yellow square is drawn parrallel to the screen. If Select 
   * == true then The manipulatros are drawn using glRenderMode(GL_SELECT)
   */
  static int DrawAxisIcon(float Size = 1.0, float Alpha = 1.0, float LineWidth = 2, bool Select = false, DWORD Flags = DRAWAXIS_NORMAL);
  /**
   * Draws the Rotate manipulator. Consiting of a RGB circles for rotation, 
   * and a yellow circle parellel to the screen for normal rotation.
   */
  static int DrawRotateIcon(float Size = 1.0, float Alpha = 1.0, float LineWidth = 1.0, bool Select = false);
  /**
   * Draws the scale manipulator simlar to the move manipulator except with boxes on the end of each
   * line, rather than arrow heads.
   */
  static int DrawScaleIcon(float Size = 1.0, float Alpha = 1.0, float LineWidth = 2, bool Select = false);
  /**
   * Draws a cuve at the origin with a side length of Size
   */
  static int DrawCube(float Size);
  /**
   * Draws an Arrow head who's fat end is at the origin, and point in the X direction
   * It has the given length, radius and alpha
   */
  static int DrawArrowHead(float Length, float Radius);
  
  // MBaseViewWnd methods
  void ViewCreate();
};


#endif