#ifndef MToolType_Header
#define MToolType_Header

#include "MNamedObject.h"
#include "MStr.h"
#include "MMath.h"

class MToolType;
typedef MRefCountedPtr<MToolType> MToolTypePtr;

#include "BaseViewWnd.h"

#define TOOLFLAGS_ANYOBJECT      0xffff
#define TOOLFLAGS_POINTS         0x0001
#define TOOLFLAGS_FACES          0x0002
#define TOOLFLAGS_EDGES          0x0004

#define TOOLRESULT_DRAWNONE       0
#define TOOLRESULT_DRAWALL        1
#define TOOLRESULT_DRAWCURRENT    2

#include <string>

//----------------------------------------------------------------------------------------
//  MToolType
//----------------------------------------------------------------------------------------
class MToolType : public MRefCountedObject {
protected:
   HWND           m_hWnd;

public:
   bool         m_RequiresSel, m_Dragging;
   MFlagObject  m_SelFlags;

   MVector3     m_DownPos, m_UpPos, m_CurPos;    // The cursor coordinates in screen space
   MRay         m_DownRay, m_CurRay;             // The cursor coordinates in world space, in Ray form.

   int          m_PickedManip;    // The current manipulator that is being used.

   std::vector<MSelectionItem> m_InputList;     // Input list of objects to use for tool selection and what not.

   MToolType();
   virtual ~MToolType();

   std::string getName();
   void setName(const std::string &name);

   bool Is(MStr Str);
   bool Is(HWND hWnd) {return m_hWnd == hWnd;};
   bool RequiresSelection() {return m_RequiresSel;};

   /**
    * this method is called when a tool is set to be the current tool. Each 
    * tool class implements this method to initialise any data, or prepare 
    * object selections or whatever.
    */
   virtual void initialise();

   /**
    * This method is called when the user wants to finish with this tool. 
    * Implementin classes override this method to perform any actions that
    * complete the tools uasage. For example, if we are creating a spline,
    * finishing off the tool would finish up where we are and go back to 
    * object mode. If we were a bone creation tool, we would just switch back
    * to the previous tool.
    *
    * The default behaviour for this is to simply go back to the previously
    * selected tool.
    *
    * @return true If we are finished with tool, and the tool manager should
    *         revert to the previosuly used tool. False if we are not finished
    *         with this tool, and we should stay on this one.
    */
   virtual bool finish();

   /**
    * This is called by the user when they want to cancel the current action
    * being performed by the tool.
    *
    * The default behaviour for this is to go back to the previosuly selected 
    * tool.
    *
    * @return true If we are finished with tool, and the tool manager should
    *         revert to the previosuly used tool. False if we are not finished
    *         with this tool, and we should stay on this one.
    */
   virtual bool cancel();
   
   virtual int DrawTool(bool Select, MShiftState ShiftState, MBaseViewWndPtr View);
   virtual int onMouseDown(int X, int Y, const MShiftState &Shift);
   virtual int onMouseUp(int X, int Y, const MShiftState &Shift);
   virtual int onMouseMove(int X, int Y, const MShiftState &Shift);
   virtual int GetDefaultManip() {return -1;};

   virtual int WrapMouse() {return 0;};

private:
  std::string toolName;
};

#endif