#ifndef MGLMoveToolType_Header
#define MGLMoveToolType_Header

#include <MXYZToolType.h>

//-------------------
//  MGLMoveToolType
//-------------------
class MGLMoveToolType : public MXYZToolType {
protected:
   MVector3 m_MoveStart;

   typedef enum { SCREEN, XAXIS, YAXIS, ZAXIS } ManipAxis;

   // This is the axis that the middle manipulator is currently
   // oriented to.
   ManipAxis middleManipAxis;
public:
   MGLMoveToolType();
   virtual int DrawTool(bool Select, MShiftState ShiftState, MBaseViewWndPtr View);
   virtual int onMouseDown(int X, int Y, const MShiftState &Shift);
   virtual int onMouseUp(int X, int Y, const MShiftState &Shift);
   virtual int onMouseMove(int X, int Y, const MShiftState &Shift);
   virtual int GetDefaultManip() {return 4;};
};

#endif