#ifndef Aztec_GLCanvas_Header
#define Aztec_GLCanvas_Header

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#define WGL_OK                      0
#define WGL_CREATECONTEXT_FAILED	  1
#define WGL_MAKECURRENT_FAILED		  2

#define GLVIEW_FONTSTART               1000
#define GLVIEW_ARROWHEADLIST           900         // yet to implement

#include <MdlConst.h>

class GLCanvas : public CWnd {
public:
  typedef enum { 
    GL_OK = 0, 
    GL_CREATECONTEXT_FAILED = 1, 
    GL_MAKECURRENT_FAILED = 2 
  } GLErrorEnum;

  GLCanvas();

  BOOL Create(DWORD style, const RECT &rect, CWnd *parent, UINT id = -1);
  GLErrorEnum killOpenGL();

  HGLRC getGLContext();
  GLErrorEnum makeCurrent(HDC dc = NULL);
  int swapBuffers(HDC dc = NULL);
  void createFonts(DWORD glListIndex, HDC dc = NULL);

  virtual void onMouseUp(int x, int y, MShiftState Shift);
  virtual void onMouseDown(int x, int y, MShiftState Shift);
  virtual void onMouseMove(int x, int y, MShiftState Shift);

  static void GLDrawText(float x, float y, const MStr &str);

  // CWnd methods
  LRESULT DefWindowProc(UINT message, WPARAM wParam, LPARAM lParam);

protected:
  GLErrorEnum initOpenGL();

private:
  HGLRC	glContext;
  bool needToCreateFonts;

};

#endif