#include "StdAfx.h"

#include <math.h>
#include "MMesh.h"
#include "scripting/ScriptTriangle.h"
#include "scripting/ScriptVector3.h"

#if defined( _DEBUG ) && defined( _MSC_VER )
// Memory leak detection for MS compiler
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

namespace Aztec {  

static JSBool
set(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval)
{
	MInternalTriangle *tri = (MInternalTriangle *)JS_GetInstancePrivate(cx, obj, &aztecTriangle_class, NULL);
	if (tri == NULL || ((argc != 1) && (argc != 3))) {
		return JS_FALSE;
	}

	if (argc == 1) {
		// Either an array of doubles or another Triangle
		if (JSVAL_IS_OBJECT(*argv)) {

			// First see if it is another Triangle
			JSObject *obj2 = JSVAL_TO_OBJECT(*argv);
			MInternalTriangle *tri2 = (MInternalTriangle *)JS_GetInstancePrivate(cx, obj2, &aztecTriangle_class, NULL);
			if (tri2 != NULL) {
				*tri = *tri2;
				*rval = JSVAL_VOID;
				return JS_TRUE;
			}

			// See if the argument is an array of numbers
			jsuint lengthp;
			if (JS_IsArrayObject(cx, obj2) == JS_TRUE &&
				JS_GetArrayLength(cx, obj2, &lengthp) == JS_TRUE &&
				lengthp >= 3) {
				jsval v1, v2, v3;
				if (JS_GetElement(cx, obj2, 0, &v1) == JS_TRUE &&
					JS_GetElement(cx, obj2, 1, &v2) == JS_TRUE &&
					JS_GetElement(cx, obj2, 2, &v3) == JS_TRUE) {
					if (JSVAL_IS_NUMBER(v1) && JSVAL_IS_NUMBER(v2) &&
						JSVAL_IS_NUMBER(v3)) {
						tri->setVertex(0, (JSVAL_IS_INT(v1) ? JSVAL_TO_INT(v1) : (int)*JSVAL_TO_DOUBLE(v1)));
						tri->setVertex(1, (JSVAL_IS_INT(v2) ? JSVAL_TO_INT(v2) : (int)*JSVAL_TO_DOUBLE(v2)));
						tri->setVertex(2, (JSVAL_IS_INT(v3) ? JSVAL_TO_INT(v3) : (int)*JSVAL_TO_DOUBLE(v3)));
						*rval = JSVAL_VOID;
						return JS_TRUE;
					}
				}
			}
		}
	} else if (argc == 3) {
		jsval v1, v2, v3;
		v1 = *argv;
		v2 = *(argv+1);
		v3 = *(argv+2);
		if (JSVAL_IS_NUMBER(v1) && JSVAL_IS_NUMBER(v2) &&
			JSVAL_IS_NUMBER(v3)) {
			tri->setVertex(0, (JSVAL_IS_INT(v1) ? JSVAL_TO_INT(v1) : (int)*JSVAL_TO_DOUBLE(v1)));
			tri->setVertex(1, (JSVAL_IS_INT(v2) ? JSVAL_TO_INT(v2) : (int)*JSVAL_TO_DOUBLE(v2)));
			tri->setVertex(2, (JSVAL_IS_INT(v3) ? JSVAL_TO_INT(v3) : (int)*JSVAL_TO_DOUBLE(v3)));
			*rval = JSVAL_VOID;
			return JS_TRUE;
		}
	}

	// Don't know how to convert the arguments into the components of
	// a triangle.
	return JS_FALSE;
}

static JSPropertySpec aztecTriangle_props[] = {
	{"i0",		0,	JSPROP_ENUMERATE},
	{"i1",		1,	JSPROP_ENUMERATE},
	{"i2",		2,	JSPROP_ENUMERATE},
	{"center",	3,	JSPROP_ENUMERATE},
	{"centre",	4,	JSPROP_ENUMERATE},
	{"normal",	5,	JSPROP_ENUMERATE},
	{0}
};

static JSFunctionSpec aztecTriangle_methods[] = {
	{"set",				set,		1},
	{0}
};

static JSBool
aztecTriangle_getProperty(JSContext *cx, JSObject *obj, jsval id, jsval *vp)
{
	MInternalTriangle *tri = (MInternalTriangle *)JS_GetInstancePrivate(cx, obj, &aztecTriangle_class, NULL);
	if (tri == NULL) {
		return JS_FALSE;
	}

	if (JSVAL_IS_STRING(id)) {
		char *propStr = JS_GetStringBytes(JS_ValueToString(cx, id));
		if (strcmp(propStr, "i0") == 0) {
			*vp = INT_TO_JSVAL(tri->getVertex(0));
			return JS_TRUE;
		} else if (strcmp(propStr, "i1") == 0) {
			*vp = INT_TO_JSVAL(tri->getVertex(1));
			return JS_TRUE;
		} else if (strcmp(propStr, "i2") == 0) {
			*vp = INT_TO_JSVAL(tri->getVertex(2));
			return JS_TRUE;
		} else if (strcmp(propStr, "center") == 0 || strcmp(propStr, "centre") == 0) {
			JSObject *vobj = newVector3(cx);
			MVector3 *vec = (MVector3 *)JS_GetInstancePrivate(cx, vobj, &aztecVector3_class, NULL);
			if (vec != NULL) {
				*vec = tri->getCentre();
				*vp = OBJECT_TO_JSVAL(vobj);
				return JS_TRUE;
			}
			return JS_FALSE;
		} else if (strcmp(propStr, "normal") == 0) {
			JSObject *vobj = newVector3(cx);
			MVector3 *vec = (MVector3 *)JS_GetInstancePrivate(cx, vobj, &aztecVector3_class, NULL);
			if (vec != NULL) {
				*vec = tri->getNormal();
				*vp = OBJECT_TO_JSVAL(vobj);
				return JS_TRUE;
			}
			return JS_FALSE;
		}

		return JS_TRUE;
	} else if (JSVAL_IS_INT(id)) {
		int index = JSVAL_TO_INT(id);
		if (index == 0) {
			*vp = INT_TO_JSVAL(tri->getVertex(0));
			return JS_TRUE;
		} else if (index == 1) {
			*vp = INT_TO_JSVAL(tri->getVertex(1));
			return JS_TRUE;
		} else if (index == 2) {
			*vp = INT_TO_JSVAL(tri->getVertex(2));
			return JS_TRUE;
		} else if ((index == 3) || (index == 4)) {
			JSObject *vobj = newVector3(cx);
			MVector3 *vec = (MVector3 *)JS_GetInstancePrivate(cx, vobj, &aztecVector3_class, NULL);
			if (vec != NULL) {
				*vec = tri->getCentre();
				*vp = OBJECT_TO_JSVAL(vobj);
				return JS_TRUE;
			}
			return JS_FALSE;
		} else if (index == 5) {
			JSObject *vobj = newVector3(cx);
			MVector3 *vec = (MVector3 *)JS_GetInstancePrivate(cx, vobj, &aztecVector3_class, NULL);
			if (vec != NULL) {
				*vec = tri->getNormal();
				*vp = OBJECT_TO_JSVAL(vobj);
				return JS_TRUE;
			}
			return JS_FALSE;
		} else {
			return JS_TRUE;
		}
	} else {
		return JS_TRUE;
	}
}

static JSBool
aztecTriangle_setProperty(JSContext *cx, JSObject *obj, jsval id, jsval *vp)
{
	MInternalTriangle *tri = (MInternalTriangle *)JS_GetInstancePrivate(cx, obj, &aztecTriangle_class, NULL);
	if (tri == NULL) {
		return JS_FALSE;
	}

	if (JSVAL_IS_STRING(id)) {
		char *propStr = JS_GetStringBytes(JS_ValueToString(cx, id));
		if (strcmp(propStr, "i0") == 0) {
			if (JSVAL_IS_NUMBER(id)) {
				tri->setVertex(0, (JSVAL_IS_INT(*vp) ? JSVAL_TO_INT(*vp) : (int)*JSVAL_TO_DOUBLE(*vp)));
				return JS_TRUE;
			}
		} else if (strcmp(propStr, "i1") == 0) {
			if (JSVAL_IS_NUMBER(id)) {
				tri->setVertex(1, (JSVAL_IS_INT(*vp) ? JSVAL_TO_INT(*vp) : (int)*JSVAL_TO_DOUBLE(*vp)));
				return JS_TRUE;
			}
		} else if (strcmp(propStr, "i2") == 0) {
			if (JSVAL_IS_NUMBER(id)) {
				tri->setVertex(2, (JSVAL_IS_INT(*vp) ? JSVAL_TO_INT(*vp) : (int)*JSVAL_TO_DOUBLE(*vp)));
				return JS_TRUE;
			}
		} else if (strcmp(propStr, "center") == 0 || strcmp(propStr, "centre") == 0) {
			if (JSVAL_IS_OBJECT(id)) {
				JSObject *obj2 = JSVAL_TO_OBJECT(*vp);
				if (obj2 != NULL) {
					MVector3 *vec = (MVector3 *)JS_GetInstancePrivate(cx, obj2, &aztecVector3_class, NULL);
					if (vec != NULL) {
            // TODO: look at this, and see if this is valid, because the centre should always be calculated from the vertices.
//						tri->m_Centre = *vec;
						return JS_TRUE;
					}
				}
			}
		} else if (strcmp(propStr, "normal") == 0) {
			if (JSVAL_IS_OBJECT(id)) {
				JSObject *obj2 = JSVAL_TO_OBJECT(*vp);
				if (obj2 != NULL) {
					MVector3 *vec = (MVector3 *)JS_GetInstancePrivate(cx, obj2, &aztecVector3_class, NULL);
					if (vec != NULL) {
            // TODO: look at this to see if it is valid, becaus the normal of a triangle should always be calculated from its vertices.
//            tri->m_Normal = *vec;
						return JS_TRUE;
					}
				}
			}
		}
	} else if (JSVAL_IS_INT(id)) {
		int index = JSVAL_TO_INT(id);
		if (index == 0) {
			if (JSVAL_IS_NUMBER(id)) {
				tri->setVertex(0, (JSVAL_IS_INT(*vp) ? JSVAL_TO_INT(*vp) : (int)*JSVAL_TO_DOUBLE(*vp)));
				return JS_TRUE;
			}
		} else if (index == 1) {
			if (JSVAL_IS_NUMBER(id)) {
				tri->setVertex(1, (JSVAL_IS_INT(*vp) ? JSVAL_TO_INT(*vp) : (int)*JSVAL_TO_DOUBLE(*vp)));
				return JS_TRUE;
			}
		} else if (index == 2) {
			if (JSVAL_IS_NUMBER(id)) {
				tri->setVertex(2, (JSVAL_IS_INT(*vp) ? JSVAL_TO_INT(*vp) : (int)*JSVAL_TO_DOUBLE(*vp)));
				return JS_TRUE;
			}
		} else if ((index == 3) || (index == 4)) {
			if (JSVAL_IS_OBJECT(id)) {
				JSObject *obj2 = JSVAL_TO_OBJECT(*vp);
				if (obj2 != NULL) {
					MVector3 *vec = (MVector3 *)JS_GetInstancePrivate(cx, obj2, &aztecVector3_class, NULL);
					if (vec != NULL) {
            // TODO: look at this and consider if it is valud or not, because the centre of a 
            //       triangle should always be calculated from its vertices.
						// tri->m_Centre = *vec;
						return JS_TRUE;
					}
				}
			}
		} else if (index == 4) {
			if (JSVAL_IS_OBJECT(id)) {
				JSObject *obj2 = JSVAL_TO_OBJECT(*vp);
				if (obj2 != NULL) {
					MVector3 *vec = (MVector3 *)JS_GetInstancePrivate(cx, obj2, &aztecVector3_class, NULL);
					if (vec != NULL) {
            // TODO: Look at this and consider if it is valid or not, since the normal should always 
            //       be calculated from its vertices.
						// tri->m_Normal = *vec;
						return JS_TRUE;
					}
				}
			}
		}
	}

	return JS_TRUE;
}

static JSBool
aztecTriangle_convert(JSContext *cx, JSObject *obj, JSType typ, jsval *vp)
{
	MInternalTriangle *tri = (MInternalTriangle *)JS_GetInstancePrivate(cx, obj, &aztecTriangle_class, NULL);
	if (tri == NULL) {
		return JS_FALSE;
	}
	
    switch (typ) {
    case JSTYPE_OBJECT:
        *vp = OBJECT_TO_JSVAL(obj);
        return JS_TRUE;
		
    case JSTYPE_VOID:
    case JSTYPE_STRING:
		{
			char buf[128];
			sprintf(buf, "%d %d %d",
				tri->getVertex(0), tri->getVertex(1), tri->getVertex(2));
			JSString *str = JS_NewStringCopyZ(cx, buf);
			*vp = STRING_TO_JSVAL(str);
			return JS_TRUE;
		}
		
	case JSTYPE_FUNCTION:
	case JSTYPE_NUMBER:
    case JSTYPE_BOOLEAN:
    default:
        return JS_FALSE;
    }
}

static void
aztecTriangle_finalize(JSContext *cx, JSObject *obj)
{
	MInternalTriangle *vec = (MInternalTriangle *)JS_GetInstancePrivate(cx, obj, &aztecTriangle_class, NULL);
	if (vec != NULL) {
		delete vec;
	}
}

JSClass aztecTriangle_class = { 
	"AztecTriangle", JSCLASS_HAS_PRIVATE, 
		JS_PropertyStub, JS_PropertyStub,					// add/del property
		aztecTriangle_getProperty, aztecTriangle_setProperty,	// get/set property
		JS_EnumerateStub, JS_ResolveStub,
		aztecTriangle_convert, aztecTriangle_finalize
};

static JSBool aztecTriangle_constructor(JSContext *cx, JSObject *obj, uintN argc,
                             jsval *argv, jsval *rval)
{
	MInternalTriangle *vec = new MInternalTriangle();
	if (vec == NULL) {
		return NULL;
	}
	JS_SetPrivate(cx, obj, vec);

	if ((argc == 0) || (set(cx, obj, argc, argv, rval) == JS_TRUE)) {
		return JS_TRUE;
	} else {
		delete vec;
		JS_SetPrivate(cx, obj, NULL);
		return JS_FALSE;
	}
}

JSObject *newTriangle(JSContext *cx)
{
	JSObject *jsvec = JS_NewObject(cx, &aztecTriangle_class, NULL, JS_GetGlobalObject(cx));

	if (jsvec == NULL) {
		return NULL;
	}

	MInternalTriangle *pvec = new MInternalTriangle();
	JS_SetPrivate(cx, jsvec, pvec);

	return jsvec;
}

void addTriangleClass(JSContext *cx)
{
	// Add a Triangle class (reflection of MTriangle3) to the global namespace
    JS_InitClass(cx, JS_GetGlobalObject(cx), NULL,
		&aztecTriangle_class, aztecTriangle_constructor, 0,
		aztecTriangle_props, aztecTriangle_methods, 0, 0);

}

}
