#include "StdAfx.h"

#include "params/MObjectParameter.h"
#include "MSystemManager.h"
#include "MDAGraph.h"

#if defined( _DEBUG ) && defined( _MSC_VER )
// Memory leak detection for MS compiler
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

namespace Aztec {

  //---------------------------------------
  //  MObjectParameter
  //---------------------------------------
  MObjectParameterImpl::MObjectParameterImpl( const MStr &shortName, 
                                      const MStr &longName, 
                                      const MStr &friendlyName) 
    : MParameterObjectImpl(shortName, longName, friendlyName, NULL) 
  {
  }

  MObjectParameterImpl::~MObjectParameterImpl() {
  }

  void MObjectParameterImpl::setValue(MNamedObjectPtr value) {
    // dont do anything if we are already set to the same value.
    if (m_Object == value) {
      return;
    }

    disconnectParameter();

    m_Object = value;
    m_ObjectName = "";

    MDAGraph::flagOutputs(this, OBJECTFLAG_NEEDS_UPDATE);

    connectParameter();
  }

  MNamedObjectPtr MObjectParameterImpl::getValue() {
    if (m_Object != NULL || m_ObjectName.GetLength() == 0) {
      updateObject();
      if (m_Object != NULL) {
        m_Object->updateObject();
      }
      return m_Object;
    }

    m_Object = AZTEC_CAST(MNamedObject, MSystemManager::getInstance()->getScene()->getObjectList()->findObject(m_ObjectName));

    connectParameter();

    return m_Object;
  }

  bool MObjectParameterImpl::getValueString(MStr &value) {
    if (m_Object != NULL) {
      value = m_Object->getName();
    } else {
      value = m_ObjectName;
    }
    return true;
  }

  bool MObjectParameterImpl::getValueInteger(int &value) {
    return false;
  }

  bool MObjectParameterImpl::getValueFloat(float &value) {
    return false;
  }

  bool MObjectParameterImpl::getValueBoolean(bool &value) {
    return false;
  }

  bool MObjectParameterImpl::getValueVector(MVector3 &value) {
    return false;
  }


  bool MObjectParameterImpl::setValueString(const MStr &value) {
    // only bother doing anything if it is different to what we currently have.
    MStr val;
    getValueString(val);
    if (val.compareNoCase(value) == 0) {
      return true;
    }

    m_Object = NULL;
    m_ObjectName = value;

    // do a get value to force it to search for the object.
    getValue();

    MDAGraph::flagOutputs(this, OBJECTFLAG_NEEDS_UPDATE);

    return true;
  }

  bool MObjectParameterImpl::setValueInteger(int value) {
    return false;
  }

  bool MObjectParameterImpl::setValueFloat(float value) {
    return false;
  }

  bool MObjectParameterImpl::setValueBoolean(bool value) {
    return false;
  }

  bool MObjectParameterImpl::setValueVector(const MVector3 &value) {
    return false;
  }

  bool MObjectParameterImpl::setValueParameter(const MParameterObjectPtr &value) {
    MObjectParameterPtr param = AZTEC_CAST(MObjectParameter, value);

    if (param == NULL) {
      MStr str;
      if (value->getValueString(str)) {
        return setValueString(str);
      }
      return false;
    }

    setValue(param->getValue());

    return true;
  }


  bool MObjectParameterImpl::createKeyAt(long time) {
    return false;
  }

  MParameterObjectPtr MObjectParameterImpl::createCopy() {
    return createParameterCopy(this);
  }

  bool MObjectParameterImpl::setInputParameter(const MParameterObjectPtr &input) {
    // disconnect the current input/output dag connectsion before setting this up.
    disconnectParameter();

    return MParameterObjectImpl::setInputParameter(input);
  }

  void MObjectParameterImpl::connectParameter() {
    // if this parameter is being controlled by another parameter,
    // do not link up the objects, since this will just introduce 
    // unncessary dependancies in the DAGraph.
    if (isConnected()) {
      return;
    }

    if (m_Object != NULL) {
      if (isInputParameter()) {
        addInput(&*m_Object);
      } else {
        addOutput(&*m_Object);
      }
    }
  }

  void MObjectParameterImpl::disconnectParameter() {
    // if this parameter is being controlled by another parameter,
    // do not link up the objects, since this will just introduce 
    // unncessary dependancies in the DAGraph.
    if (isConnected()) {
      return;
    }

    if (m_Object != NULL) {
      if (isInputParameter()) {
        removeInput(&*m_Object);
      } else {
        removeOutput(&*m_Object);
      }
    }
  }

}
