#include "StdAfx.h"

#include "MSystemManager.h"
#include "MDAGraph.h"

#include <algorithm>

#if defined( _DEBUG ) && defined( _MSC_VER )
// Memory leak detection for MS compiler
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

namespace Aztec {
  //-----------------------
  //  MIntParameterAdapter
  //-----------------------
  bool MIntParameterAdapter::getValueString(MStr &value) {
    value.Format("%i", getValue());
    return true;
  }

  bool MIntParameterAdapter::getValueInteger(int &value) {
    value = (int)(getValue() + 0.5);
    return true;
  }

  bool MIntParameterAdapter::getValueFloat(float &value) {
    value = (float)getValue();
    return true;
  }

  bool MIntParameterAdapter::getValueBoolean(bool &value) {
    value = (getValue() >= 1);
    return true;
  }

  bool MIntParameterAdapter::getValueVector(MVector3 &value) {
    return false;
  }

  bool MIntParameterAdapter::setValueString(const MStr &value) {
    return setValueInteger(value.ToInt());
  }

  bool MIntParameterAdapter::setValueFloat(float value) {
    return setValueInteger((int)value);
  }

  bool MIntParameterAdapter::setValueBoolean(bool value) {
    if (value) {
      return setValueInteger(1);
    } else {
      return setValueInteger(0);
    }
  }

  bool MIntParameterAdapter::setValueVector(const MVector3 &value) {
    return false;
  }

  bool MIntParameterAdapter::setValueParameter(const MParameterObjectPtr &value) {
    int val;

    if (value->getValueInteger(val)) {
      setValueInteger(val);
      return true;
    }

    return false;
  }

  MParameterObjectPtr MIntParameterAdapter::createCopy() {
    MParameterObjectPtr newParam = new MIntParameterImpl(getShortName(), getLongName(), getFriendlyName());
    newParam->setFromParameter(this);
    return newParam;
  }

  //------------------
  //  MIntParameter
  //------------------
  MIntParameterImpl::MIntParameterImpl(const MStr &shortName, const MStr &longName, const MStr &friendlyName) 
    : MParameterObjectImpl(shortName, longName, friendlyName, NULL)
  {
    m_Value = 0;
  }
  
  MIntParameterImpl::~MIntParameterImpl() {
  }

  int MIntParameterImpl::getValue() { 
    updateObject();
    return m_Value; 
  }

  bool MIntParameterImpl::setValueInteger(int value) {
    doEnsureUndo(intUndo, this);
    m_Value = value;
    MDAGraph::flagOutputs(this, OBJECTFLAG_NEEDS_UPDATE);
    return true;
  }

  void MIntParameterImpl::finishWithUndoNode() {
    intUndo = NULL;
    MParameterObjectImpl::finishWithUndoNode();
  }

  MIntParameterImpl::Undo::Undo(MIntParameterImpl *param) {
    object = param;
    stored = param->m_Value;
  }

  MUndoableObject* MIntParameterImpl::Undo::getObject() {
    return &*object;
  }

  void MIntParameterImpl::Undo::undo() {
    std::swap(object->m_Value, stored);
  }

  void MIntParameterImpl::Undo::redo() {
    std::swap(object->m_Value, stored);
  }

  
}
