#include "StdAfx.h"

#include <mesh/MEditMeshModifier.h>
#include <MEditableMesh.h>
#include <params/MParameterFactory.h>

#if defined( _DEBUG ) && defined( _MSC_VER )
// Memory leak detection for MS compiler
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

namespace Aztec {

  MEditMeshModifier::MEditMeshModifier() {
    setFlag(OBJECTFLAG_NEEDS_UPDATE);

    meshShape = new MMeshShape;
    meshShape->setName("editMeshMeshShape");
    storedMeshShape = MParameterFactory::createObject("storedMesh", "storedMesh", "Stored Mesh");
    storedMeshShape->setVisible(false);
    storedMeshShape->setValue(meshShape);

    addParameter(storedMeshShape);

    getOutputParameter()->setInputParameter(storedMeshShape);
  }

  MEditMeshModifier::~MEditMeshModifier() {
  }

  MStr MEditMeshModifier::getClassName() {
    return "MEditMeshModifier";
  }

  MBaseObjectPtr MEditMeshModifier::createNew() {
    MEditMeshModifierPtr newObject = new MEditMeshModifier;

    return newObject;
  }
  
  bool MEditMeshModifier::doUpdateObject() {
    MMeshShapePtr outMeshShape = getOutputShape();

    // Now place an editable copy of the input mesh into the output shape
    MMeshShapePtr inMeshShape = getInputShape();

    if (inMeshShape != NULL && outMeshShape != NULL) {
      MMeshPtr mesh = new MEditableMesh(inMeshShape->getMeshObject());
      meshShape->setMeshObject(mesh);

      mesh->setName(getName() + "StoredMesh");
      return true;
    }

    return false;
  }

}
