#include "StdAfx.h"
#include "MStr.h"


#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <ctype.h>
#include <assert.h>


#if defined( _DEBUG ) && defined( _MSC_VER )
// Memory leak detection for MS compiler
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

MStr::MStr() {
#if 0
	m_String = new char[1];
	m_String[0] = '\0';
#else
	m_String = NULL;
#endif
}

MStr::MStr(const MStr &Src) {
  if (Src.m_String) {
    m_String = new char[strlen(Src.m_String)+1];
    strcpy(m_String, Src.m_String);
  }	else {
    m_String = NULL;
  }
}

MStr::MStr(const long Src) {
  char buf[32];

  sprintf("%i", buf, Src);
  
  m_String = new char[strlen(buf)+1];
  strcpy(m_String, buf);	
}


MStr::MStr(const char *Src) {
  if (Src) {
    m_String = new char[strlen(Src)+1];
    strcpy(m_String, Src);
  } else {
    m_String = NULL;
  }
}

MStr::MStr(const char Src) {
  if (Src) {
    m_String = new char[2];
    m_String[0] = Src;
    m_String[1] = '\x0';
  } else {
    m_String = NULL;
  }
}

MStr::MStr(const std::string &str) 
{
  if (str.length() > 0) {
    m_String = new char[str.length() + 1];
    strcpy(m_String, str.c_str());
  } else {
    m_String = NULL;
  }
}


MStr::~MStr() {
  if (m_String)
    delete[] m_String;
}

int MStr::GetLength() const {
  if (m_String)
    return strlen(m_String);
  
  return 0;
}

MStr& MStr::operator=(const MStr &Src) {
  // Make sure we assigning itself to itself.
  if (m_String == Src.m_String) {
    return *this;
  }
  
  
  if (m_String) {
    delete[] m_String;
  }
  
  if (Src.m_String)	{
    m_String = new char[strlen(Src.m_String)+1];
    strcpy(m_String, Src.m_String);
  }	else {
    m_String = NULL;
  }
  
  return *this;
}

MStr& MStr::operator=(LPCTSTR Src) {
  if (m_String) {
    delete[] m_String;
  }
  
  if (Src) {
    m_String = new char[strlen(Src)+1];
    strcpy(m_String, Src);
  }	else {
    m_String = NULL;
  }
  
  return *this;
}

MStr& MStr::operator=(char Src) {
  char S[2];
  S[0] = Src;
  S[1] = '\x0';
  return *this = S;
}

MStr& MStr::operator+=(const MStr &Src) {
  char *temp;
  
  if (!Src.m_String) {
    return *this;
  }
  
  if (m_String)	{
    temp = new char[strlen(m_String) + strlen(Src.m_String) + 1];
    strcpy(temp, m_String);
  }	else {
    temp = new char[strlen(Src.m_String) + 1];
    temp[0] = '\x0';
  }
  
  strcat(temp, Src.m_String);
  delete[] m_String;
  m_String = temp;
  
  return *this;
}

int MStr::operator==(const MStr &RHS) {	
	if (!m_String) {
		if (!RHS.m_String) {
			return 1;
		} else {
			return 0;
		}
	} else if (!RHS.m_String) {
		return 0;
	}
	
	if (strcmp(m_String, RHS.m_String) == 0)
		return 1;
	return 0;
}

int MStr::operator==(LPCTSTR RHS) {
	if (!m_String) {
		if (!RHS) {
			return 1;
		} else {
			return 0;
		}
	} else if (!RHS) {
		return 0;
	}
	
	if (strcmp(m_String, RHS) == 0)
		return 1;
	return 0;
}

int MStr::operator!=(const MStr &RHS) const {
	if (!m_String) {
		if (!RHS.m_String) {
			return 0;
		} else {
			return 1;
		}
	} else if (!RHS.m_String) {
		return 1;
	}
	
	if (strcmp(m_String, RHS.m_String) == 0)
		return 0;
	return 1;
}

int MStr::operator!=(LPCTSTR RHS) const {
	if (!m_String) {
		if (!RHS) {
			return 0;
		} else {
			return 1;
		}
	} else if (!RHS) {
		return 1;
	}
	
	if (strcmp(m_String, RHS) == 0)
		return 0;
	return 1;
}


char& MStr::operator[](int Index) {
  // Have this char, if the index is out of range, return this. Causes no harm by changing out
  // of bounds chars.
  static char OutOfBoundsChar;
  
  OutOfBoundsChar = 0;
  
  if (Index >= GetLength() || Index<0) {
    return OutOfBoundsChar;
  }
		
  return m_String[Index];
}


int MStr::compareNoCase(const MStr &Src) const {
  if (!m_String || !Src.m_String) {
    return -1;
  }
  
#ifdef WIN32 
  return strcmpi(m_String, Src.m_String);
#else
  return strcasecmp(m_String, Src.m_String);
#endif
}


long MStr::ToInt() const {
  if (!m_String) {
    return 0;
  }
  
  return atol(m_String);
}

float MStr::ToFloat() const {
  if (!m_String) {
    return 0;
  }
  
  return (float)atof(m_String);
}

DWORD MStr::ToDWORD() const {
  return (DWORD)atol(m_String);
}

MStr& MStr::FromBinary(DWORD Val, int MinDigits) {
  if (m_String)
    delete[] m_String;
  
  m_String = new char[33];
  memset(m_String, 0, 33);
  
  
  int      n;
  char     *CurChar;
  DWORD    CompareVal;
  
  CompareVal = 1 << 31;
  CurChar = m_String;
  
  for (n=MinDigits-1; n>=0; n--) {
    CompareVal = 1 << n;
    if (Val & CompareVal) {
      *CurChar = '1';
    } else {
      *CurChar = '0';
    }
    
    CompareVal = CompareVal >> 1;
    CurChar++;
  }
  
  return *this;
}

void MStr::Replace(char Find, char Rep) {
  if (!m_String) {
    return;
  }
  
  int      Len;
  char     *Str;
  
  Len = strlen(m_String);
  
  Str = m_String;
  while (Len--) {
    if (*Str == Find)
      *Str = Rep;
    Str ++;
  }
}

MStr& MStr::Format(const char *FormatStr, ...) {
  char        Str[1024];
  va_list     ParamList;
  
  va_start(ParamList, FormatStr);
  vsprintf(Str, FormatStr, ParamList);
  va_end(ParamList);
  
  *this = Str;
  return *this;
}

// Separate this string into a number of string, separating by spaces, tabs, or whitespace
// Returns number of params processed
int MStr::Separate(MStr *DestArray, int MaxParams) const {
  MStr  Copy;
  char  *Str, *Start;
  int   StrNum = 0;
  
  Copy = *this;
  
  Str = Copy.m_String;
  
  if (!Str) {
    return 0;
  }
  
  while (*Str) {
    while (!isgraph(*Str) || *Str == ' ') {
      Str++;
    }
    
    Start = Str;
    
    while (isgraph(*Str) && *Str != ' ') {
      Str++;
    }
    
    // chech if we are at the end of the string
    if (*Str == '\x0') {
      DestArray[StrNum] = Start;
      StrNum++;
      break;
    }
    
    // we are now at the end of the current string block.
    *Str = '\x0';
    DestArray[StrNum] = Start;
    
    Str++;
    StrNum++;
  }
  return StrNum;
}

MStr& MStr::RemoveLeading(char C) {
  if (!m_String) {
    return *this;
  }
  
  char  *NewStr, *OldStr;
  
  NewStr = new char[strlen(m_String)+1];
  OldStr = m_String;
  
  while (*OldStr == C) {
    OldStr++;
  }
  
  strcpy(NewStr, OldStr);
  delete[] m_String;
  m_String = NewStr;
  
  return *this;
}

MStr& MStr::RemoveTrailing(char C) {
  if (!m_String) {
    return *this;
  }
  
  char  *NewStr, *OldStr, *EndOldStr;
  
  NewStr = new char[strlen(m_String)+1];
  OldStr = m_String;
  
  EndOldStr = OldStr + strlen(OldStr);
  EndOldStr--;
  while (*EndOldStr == C) {
    *EndOldStr = '\x0';
    EndOldStr--;
  }
  
  strcpy(NewStr, OldStr);
  delete[] m_String;
  m_String = NewStr;
  
  return *this;
}

int MStr::SplitPath(MStr *Drive, MStr *Path, MStr *File, MStr *Ext) const {

#ifdef WIN32 
  char     szDrive[_MAX_DRIVE], szPath[_MAX_DIR], szFile[_MAX_FNAME], szExt[_MAX_EXT];
  
  _splitpath(m_String, szDrive, szPath, szFile, szExt);
  
  if (Drive) *Drive = szDrive;
  if (Path) *Path = szPath;
  if (File) *File = szFile;
  if (Ext) *Ext = szExt;

#else

  // if we are on unix, then we do not have a driver letter, so 
  // only split the path, file and extention.

  if (Drive != NULL) {
    *Drive = "";
  }

  int slashPos = -1, dotPos = -1;

  for (int index = this->GetLength(); index > 0; --index) {
    if ((*Path)[index] == '.' && slashPos == -1) {
      dotPos = index;
    } else if ((*Path)[index] == '/') {
      slashPos = index;
      break;
    }
  }

  // if we just have a filename.
  if (dotPos == -1 && slashPos == -1) {
    if (Path != NULL) {
      *Path = "";
    }
    if (File != NULL) {
      *File = m_String;
    }
    if (Ext != NULL) {
      *Ext = "";
    }
  } else if (slashPos == -1) {
    if (Path != NULL) {
      *Path = "";
    }
    if (File != NULL) {
      for (int index = 0; index < dotPos; ++index) {
        *File += m_String[index];
      }
    }
    if (Ext != NULL) {
      for (int index = dotPos + 1; index < this->GetLength(); ++index) {
        *Ext += m_String[index];
      }
    }
  } else if (dotPos == -1) {
    if (Path != NULL) {
      for (int index = 0; index < slashPos; ++index) {
        *Path += m_String[index];
      }
    }
    if (File != NULL) {
      for (int index = slashPos + 1; index < this->GetLength(); ++index) {
        *File += m_String[index];
      }
    }
    if (Ext != NULL) {
      *Ext = "";
    }
  } else {
    if (Path != NULL) {
      for (int index = 0; index < slashPos; ++index) {
        *Path += m_String[index];
      }
    }
    if (File != NULL) {
      for (int index = slashPos + 1; index < this->GetLength(); ++index) {
        *File += m_String[index];
      }
    }
    if (Ext != NULL) {
      for (int index = dotPos + 1; index < this->GetLength(); ++index) {
        *Ext += m_String[index];
      }
    }
  }

#endif
  
  return 1;
}

int MStr::findSubstring(const MStr &sub) {
  char *found;
  
  found = strstr(m_String, sub.c_str());
  
  if (found == NULL) return -1;
  
  return found - m_String;
}

MStr& MStr::toLower() {

  if (m_String != NULL) {
    for (char *ptr = m_String; *ptr != '\0'; ++ptr) {
      *ptr = tolower(*ptr);
    }
  }

  return *this;
}

MStr& MStr::toUpper() {

  if (m_String != NULL) {
    for (char *ptr = m_String; *ptr != '\0'; ++ptr) {
      *ptr = toupper(*ptr);
    }
  }

  return *this;
}

//--------------------------------------------------------------------
MStr operator+(const MStr &Left, const MStr &Right) {
  MStr  Temp;
  
  Temp += Left;
  Temp += Right;
  return Temp;
}

namespace Aztec {

  bool strToBool(const MStr &value) {
    if (value.ToInt() != 0 ||
        value.compareNoCase("true") ||
        value.compareNoCase("yes") || 
        value.compareNoCase("on")) 
    {
      return true;
    } else if (value.ToInt() == 0 ||
        value.compareNoCase("false") ||
        value.compareNoCase("no") || 
        value.compareNoCase("off")) 
    {
      return false;
    }

    return false;
  }

  MStr boolToStr(bool value) {
    return value ? "true" : "false";
  }

  float strToFloat(const MStr &value) {
    return (float)strtod(value.c_str(), NULL);
  }

  MStr floatToStr(float value) {
    char buf[64];
    sprintf(buf, "%.4f", value);
    return buf;
  }

  int strToInt(const MStr &value) {
    return atoi(value.c_str());
  }

  MStr intToStr(int value) {
    char buf[64];
    sprintf(buf, "%i", value);
    return buf;
  }

}