#include "StdAfx.h"

#include <MSelectionItem.h>

#if defined( _DEBUG ) && defined( _MSC_VER )
// Memory leak detection for MS compiler
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


namespace Aztec {

  MSelectionItem::MSelectionItem() {
    m_Object = NULL;
  
  }

  MSelectionItem::MSelectionItem(const MSelectionItem &src) {
    m_Object = src.m_Object;
    components = src.components;
  
  }

  MSelectionItem::MSelectionItem(MBaseObjectPtr SelObj) {
    m_Object = NULL;
    setObject(SelObj);
  }

  MSelectionItem::~MSelectionItem() {
    setObject(NULL);
    removeAllComponents();
  }

  void MSelectionItem::setObject(MBaseObjectPtr Obj) {
    m_Object = Obj;
  }

  MBaseObjectPtr MSelectionItem::getObject() const {
    return m_Object;
  }

  void MSelectionItem::addComponent(AztecFlags Type, int CompNum) {
    components.push_back(ComponentType(Type, CompNum));
  }

  void MSelectionItem::removeAllComponents() {
    components.clear();
  }

  int MSelectionItem::getNumComponents() const {
    return components.size();
  }

  void MSelectionItem::getComponent(int Num, AztecFlags &Type, int &CompNum) const {
    Type = components[Num].first;
    CompNum = components[Num].second;
  }

}
