#include "StdAfx.h"

#include "MBinaryFileStream.h"

#include <ctype.h>
#include <string.h>
#include <stdlib.h>

#include <assert.h>

#if defined( _DEBUG ) && defined( _MSC_VER )
// Memory leak detection for MS compiler
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

namespace Aztec {

  //--------------------------
  // MBinaryFileReader
  //--------------------------

  MBinaryFileReader::MBinaryFileReader() { 
    m_FileHandle = NULL;
  }

  MBinaryFileReader::MBinaryFileReader(const MStr &filename) { 
    m_FileHandle = NULL;
    open(filename);
  }

  MBinaryFileReader::~MBinaryFileReader() {
    close();
  }

  bool MBinaryFileReader::open(const MStr &filename) { 
    if (isOpen()) {
      close();
    }

    // open the file for reading in text mode
    m_FileHandle = ::fopen(filename.c_str(), "rb");

    return (m_FileHandle != NULL);
  }

  void MBinaryFileReader::close() { 
    if (isOpen()) {
      ::fclose(m_FileHandle);
      m_FileHandle = NULL;
    }
  }

  bool MBinaryFileReader::isOpen() { 
    return m_FileHandle != NULL;
  }

  bool MBinaryFileReader::isAtEOF() { 
    return feof(m_FileHandle) != 0;
  }

  template <class TYPE> TYPE readData(FILE *stream) {
    TYPE result;
    fread((void*)&result, 1, sizeof(TYPE), stream);
    return result;
  }

  char MBinaryFileReader::readChar() { 
    return readData<char>(m_FileHandle);
  }

  unsigned char MBinaryFileReader::readUnsignedChar() {
    return readData<unsigned char>(m_FileHandle);
  }

  short MBinaryFileReader::readShort() {
    return readData<short >(m_FileHandle);
  }

  unsigned short MBinaryFileReader::readUnsignedShort() {
    return readData<unsigned short>(m_FileHandle);
  }

  int MBinaryFileReader::readInt() { 
    return readData<int>(m_FileHandle);
  }

  unsigned int MBinaryFileReader::readUnsignedInt() {
    return readData<unsigned int>(m_FileHandle);
  }

  float MBinaryFileReader::readFloat() {
    return readData<float>(m_FileHandle);
  }

  double MBinaryFileReader::readDouble() {
    return readData<double>(m_FileHandle);
  }

  bool MBinaryFileReader::readBoolean() {
    return readData<bool >(m_FileHandle);
  }

  MStr MBinaryFileReader::readString() { 
    MStr result;
    char ch;

    // keep reading chars until we hit a null
    while ((ch = readChar()) != 0) {
      result += ch;
    }

    return result;
  }

  int MBinaryFileReader::readBuffer(void *buffer, int bufSize) {
    fread(buffer, 1, bufSize, m_FileHandle);
    return bufSize;
  }


  //--------------------------
  // MBinaryFileWriter
  //--------------------------

  MBinaryFileWriter::MBinaryFileWriter() { 
    m_FileHandle = NULL;
  }

  MBinaryFileWriter::MBinaryFileWriter(const MStr &filename, bool append) {
    m_FileHandle = NULL;
    open(filename, append);
  }

  MBinaryFileWriter::~MBinaryFileWriter() {
    close();
  }

  bool MBinaryFileWriter::open(const MStr &filename, bool append) {
    if (isOpen()) {
      close();
    }

    // open the file writing for in text mode
    if (append) {
      m_FileHandle = ::fopen(filename.c_str(), "ab");
    } else {
      m_FileHandle = ::fopen(filename.c_str(), "wb");
    }

    return (m_FileHandle != NULL);
  }

  void MBinaryFileWriter::close() { 
    if (isOpen()) {
      ::fflush(m_FileHandle);
      ::fclose(m_FileHandle);
      m_FileHandle = NULL;
    }
  }

  bool MBinaryFileWriter::isOpen() { 
    return m_FileHandle != NULL;
  }

  bool MBinaryFileWriter::isAtEOF() { 
    return feof(m_FileHandle) != 0;
  }

  template <class TYPE> void writeData(TYPE data, FILE *stream) {
    fwrite((const void*)&data, 1, sizeof(TYPE), stream);
  }

  void MBinaryFileWriter::writeChar(char value) {
    writeData<char>(value, m_FileHandle);
  }

  void MBinaryFileWriter::writeUnsignedChar(unsigned char value) {
    writeData<unsigned char>(value, m_FileHandle);
  }

  void MBinaryFileWriter::writeShort(short value) {
    writeData<short>(value, m_FileHandle);
  }

  void MBinaryFileWriter::writeUnsignedShort(unsigned short value) {
    writeData<unsigned short>(value, m_FileHandle);
  }
  
  void MBinaryFileWriter::writeInt(int value) {
    writeData<int>(value, m_FileHandle);
  }

  void MBinaryFileWriter::writeUnsignedInt(unsigned int value) {
    writeData<unsigned int>(value, m_FileHandle);
  }

  void MBinaryFileWriter::writeFloat(float value) {
    writeData<float>(value, m_FileHandle);
  }

  void MBinaryFileWriter::writeDouble(double value) {
    writeData<double>(value, m_FileHandle);
  }

  void MBinaryFileWriter::writeBoolean(bool value) {
    writeData<bool>(value, m_FileHandle);
  }

  void MBinaryFileWriter::writeString(const MStr &value) {
    fwrite(value.c_str(), 1, strlen(value.c_str())+1, m_FileHandle);
  }

  void MBinaryFileWriter::writeString(const char *value) {
    fwrite(value, 1, strlen(value)+1, m_FileHandle);
  }

  void MBinaryFileWriter::writeBuffer(const void *buffer, int bufSize) {
    fwrite(buffer, 1, bufSize, m_FileHandle);
  }

}

