#ifndef TRANSLATOR_H
#define TRANSLATOR_H

#include "ModelGeneric.h"

namespace Aztec {
  
  class MSceneTranslator;
  typedef MRefCountedPtr<MSceneTranslator> MSceneTranslatorPtr;

}

#include <translator/MTranslator.h>
#include <MScene.h>

// Scene translators are the basis for any complex geometry or higher level files. 
// this includes any Geometry that has animation.
namespace Aztec {
  
  class MGENEXPORT MSceneTranslator : public MTranslator {
  public:
    virtual bool importFile(MStr Filename, MScenePtr Scene);
    virtual bool exportFile(MStr Filename, MScenePtr Scene);
  };
}
#endif
