#ifndef SCRIPTUTILS_H
#define SCRIPTUTILS_H

#include <scripting/MScriptInterp.h>
#include <scripting/ScriptCallbacks.h>
#include <params/MArrayParameter.h>
#include <MSystemManager.h>

namespace Aztec {

extern MScenePtr getScenePointer();
extern MBaseObjectTreePtr getAllSceneObjects();
extern MBaseObjectPtr findNamedObject(const char *name);
extern void updateParamObject(const MNamedObjectPtr &obj);

// Simple support class for building enumerators.
class MGENEXPORT AztecEnumState {
public:
	int numParams;	// Total # of parameters to iterate over
	int index;		// Current property index
};

MGENEXPORT jsval convertParam(JSContext *cx, 
                   JSObject *obj,
                   const MNamedObjectPtr &aztec_obj, 
                   const MParameterObjectPtr &aztec_param);

MGENEXPORT jsval convertParam(JSContext *cx, 
                   JSObject *obj,
                   const MNamedObjectPtr &aztec_obj, 
                   const MArrayParameterPtr &aztec_param,
                   int elementIndex);

}

#endif // SCRIPTUTILS_H
