#ifndef MUniqueNameParameter_Header
#define MUniqueNameParameter_Header

#include "params/MStringParameter.h"

#include <set>
#include <string>

namespace Aztec {
  
  class MUniqueNameParameter;
  typedef MRefCountedPtr<MUniqueNameParameter> MUniqueNameParameterPtr;

  class MNamedObject;

  //---------------------------------------
  //  MUniqueNameParameter
  //---------------------------------------
  class MGENEXPORT MUniqueNameParameter : public MStringParameterImpl {
  public:
    MUniqueNameParameter(MNamedObject *namedObject = NULL, 
                         const MStr &shortName = "", 
                         const MStr &longName = "", 
                         const MStr &friendlyName = "");
    ~MUniqueNameParameter();

    // MParameterObject methods.
    bool setValueString(const MStr &value);

    // MBaseObject methods
    MStr getClassName() { return MStr("MUniqueNameParameter"); }

  private:
    MNamedObject *namedObj;
  };

}

//#include <MNamedObject.h>

#endif
