#ifndef MStringParameter_Header
#define MStringParameter_Header

#include "ModelGeneric.h"

namespace Aztec {
  
  class MStringParameter;
  typedef MRefCountedPtr<MStringParameter> MStringParameterPtr;

}

#include <MParameterObject.h>
#include <MBaseUndoNode.h>

namespace Aztec {

  //---------------------------------------
  //  MStringParameter
  //---------------------------------------
  class MGENEXPORT MStringParameter : public virtual MParameterObject {
  public:
  };

  class MGENEXPORT MStringParameterImpl : public virtual MStringParameter, 
                                          public MParameterObjectImpl
  {

  public:
    MStringParameterImpl(const MStr &shortName = "", 
                         const MStr &longName = "", 
                         const MStr &friendlyName = "",
                         int meaning = MEANING_ANY);
    ~MStringParameterImpl();

    // MParameterObject methods.
    int getDataType() const { return TYPE_STRING; }
    int getDataMeaning() const;

    bool getValueString(MStr &value);
    bool getValueInteger(int &value);
    bool getValueFloat(float &value);
    bool getValueBoolean(bool &value);
    bool getValueVector(MVector3 &value);

    bool setValueString(const MStr &value);
    bool setValueInteger(int value);
    bool setValueFloat(float value);
    bool setValueBoolean(bool value);
    bool setValueVector(const MVector3 &value);
    bool setValueParameter(const MParameterObjectPtr &value);

    MParameterObjectPtr createCopy();

    // MUndoableObject methods
    void finishWithUndoNode();

  protected:
    void ensureUndo();

    MStr m_Value;
    int meaning;
    
    class StringUndoNode : public MBaseUndoNode {
    public:
      StringUndoNode(MStringParameterImpl *param);
      // MBaseUndoNode methods
      MUndoableObject* getObject();
      void undo();
      void redo();

      MRefCountedPtr<MStringParameterImpl> param;
      std::string value;
    };        

    MRefCountedPtr<StringUndoNode> undoNode;

    friend class StringUndoNode;
  };

}

#endif
