#ifndef UndoManager_Header
#define UndoManager_Header

#include "ModelGeneric.h"

namespace Aztec {

  class MUndoManager;
  
  typedef MRefCountedPtr<MUndoManager> MUndoManagerPtr;

}

#include "MBaseUndoNode.h"
#include <deque>
#include <vector>

namespace Aztec {

/*  class UndoNodeList : public std::vector<MBaseUndoNodePtr> {
  public:
    UndoNodeList();
    UndoNodeList(const UndoNodeList &src);
    void setName(const char *name);
    const char* getName();

  private:
    std::string name;
  };
  */
  typedef std::vector<MBaseUndoNodePtr> UndoNodeList;


  template <class UndoType, class ObjectType>
  void doEnsureUndo(UndoType &undoNode, ObjectType obj) {
    if (undoNode == NULL && MUndoManager::isEnabled()) {
      undoNode = new UndoType::PtrType(obj);
      MUndoManager::getInstance()->addUndoNode(undoNode);
    }
  }

  /**
   * This is the undo manager for the system. It is responsible
   * for keeping track of undo and redo information, and 
   * for executing them when required.
   */
  class MGENEXPORT MUndoManager : public MRefCountedObject {
  public:
    static MUndoManager* getInstance();

    MUndoManager();
    ~MUndoManager();
  
    static bool isEnabled();

    /**
     * This places an undo node at the front of the undo list
     */
    void addUndoNode(MBaseUndoNodePtr node);

    /**
     * This undo's the undo node a the front of the undo list,
     * and places it onto the redo stack.
     */
    void undo();

    /**
     * This redoes the most recent node on the redo stack,
     * and places the reversed node onto the undo stack.
     */
    void redo();

    /**
     * This returns the display name for the top most undo node
     */
    MStr getUndoDisplayName();

    /**
     * This returns the display name for the top most redo node
     */
    MStr getRedoDisplayName();

    /**
     * Clears all the undo information
     */
    void clearUndoInfo();

    /**
     * Gets the current number of undo nodes on the stack
     */
    int getNumUndoNodes() {return m_UndoStack.size();}

    /**
     * @reutrn the maximum number of undo nodes allowed. -1
     * if there is no limit.
     */
    int getMaxUndos() { return m_MaxUndos; }

    /**
     * sets the maximum number of undos
     */
    void setMaxUndos(int max) { m_MaxUndos = max; }


    /**
     * This starts of a section of undo information. (Not Yet implemented)
     */
    void beginUndo(const std::string &name);

    /**
     * This ends of a section of undo information (Not Yet implemented)
     */
    void endUndo();

    /**
     * This is a very basic class which simplifies the beginning and ending of
     * undo sections. in the constructor, the undo object starts a undo 
     * section, and finishes off that section in the destructor. Using this 
     * enables the author to not worry about ending the undo section during 
     & early returns or exceptions, or thing like that, as it happens in the 
     * object's destructor.
     */
    class MGENEXPORT UndoSection {
    public:
      UndoSection(const std::string &undoName);
      ~UndoSection();
    };

  protected:
    UndoNodeList currentNodeList;

    /**
     * This is the undo stack
     */
    std::deque<UndoNodeList> m_UndoStack;

    /**
     * This is the redo stack.
     */
    std::deque<UndoNodeList> m_RedoStack;

    /**
     * This is the maximum number of undo nodes allowed in the stack.
     * It is -1 if unlimted number of undos are allowed.
     */
    int m_MaxUndos;
  
    static void doNodeList(const UndoNodeList &nodeList, bool undo);

    int undoDepth;
    bool enabled;

  };

}

#endif
