#ifndef UIManager_Header
#define UIManager_Header

#include "ModelGeneric.h"
#include "MListener.h"
#include <MComponentisedObject.h>

#include <map>

namespace Aztec {
  class MGENEXPORT MUIManager {
  public:
    static const int COMPONENT_MODE_LISTENER;
    static const int AXIS_MODE_LISTENER;
    static const int SEPARATE_AXIS_LISTENER;
    static const int SNAP_MODE_LISTENER;
    static const int COORDINATE_FEEDBACK_LISTENER;

    typedef MComponentisedObject::ComponentType ComponentType;

    enum { WORLD_AXIS = 1, LOCAL_AXIS = 2, PARENT_AXIS = 3, SCREEN_AXIS = 4, OBJECT_AXIS = 5 };

    typedef enum { SNAP_NONE = 0, SNAP_GRID = 1,SNAP_POINT = 2 } SnapModeType;

    MUIManager();
    ~MUIManager();

    static ComponentType getComponentMode();
    static void setComponentMode(ComponentType mode);

    static int getAxisMode();
    static void setAxisMode(int mode);

    static bool getSeparateAxisMode();
    static void setSeparateAxisMode(bool mode);

    static SnapModeType getSnapMode();
    static void setSnapMode(SnapModeType mode);

    static void setWorldCoordinates(const MVector3 &coords);
    static void setDiffCoordinates(const MVector3 &coords);
    static void unsetWorldCoordinates();
    static void unsetDiffCoordinates();
    static void unsetCoordinates();

    static bool getWorldCoordinates(MVector3 &coords);
    static bool getDiffCoordinates(MVector3 &coords);

    static void addListener(int action, MListenerPtr listener);
    static void removeListener(int action, MListenerPtr listener);

    static void removeAllListeners();

    typedef enum { Frames = 0, Ticks = 1, MinutesSecondsMilliseconds = 2} TimeStampEnum;

    /**
     * This retrieves the current way the user wishes to see time data 
     * represented on the screen.
     */
    static TimeStampEnum getUserTimeStamp();

    /**
     * This sets the current way the user wishes to see time data represented 
     * on the screen. This does not cause a refresh on the user interface, so
     * that must be done by the client application.
     */
    static void setUserTimeStamp(TimeStampEnum stamp);

    /**
     * This converts a tick number into the current time stamp format the user 
     * has chosen.
     */
    static std::string tickCountToTimeStamp(int tick);

  };
}

#endif // !defined(AFX_MSHELFMANAGER_H__C086F8B1_43EA_11D3_9A64_0040332C7B2F__INCLUDED_)
