#ifndef MMaterial_H
#define MMaterial_H

#include "ModelGeneric.h"

namespace Aztec {

  class MMaterial;

  typedef MRefCountedPtr<MMaterial> MMaterialPtr;

}

#include "MNamedObject.h"
#include "MImages.h"

namespace Aztec {
  
  //------------
  //  MMaterial
  //------------
  class MGENEXPORT MMaterial : public MNamedObject {
  protected:
    MImagePtr m_DiffuseMap;
    MStr m_DiffuseMapFile, m_DiffuseMapFileError;
    
  public:
    
    MMaterial();
    virtual ~MMaterial();
    
    // Class related
    virtual MStr getClassName() {return MStr("MMaterial");};
    virtual MStr getParentClassName() {return MStr("MNamedObject");};
    virtual MBaseObjectPtr createNew();
    virtual void setFrom(MBaseObjectPtr SrcObj);
    
    // Image related
    void clearImages();
    void loadImagesFromMaps();
    void setDiffuseMapImage(MImagePtr Image);
    void setDiffuseMapFilename(const MStr &Filename);
    MImagePtr getDiffuseMapImage() {return m_DiffuseMap;};
    
    // OpenGL related
    void setOpenGLMaterialAndTextures();
    
    void updateKey(int Time, DWORD Channel, bool CreateKey);
    
  };

}
#endif



