#ifndef MKeyHeader
#define MKeyHeader

#include "ModelGeneric.h"

namespace Aztec {
  class MKey;
  typedef MRefCountedPtr<MKey> MKeyPtr;
}

#include "MDAGNode.h"
#include "MKeyList.h"

namespace Aztec {

  /**
   * This is an interface class that all Key types derive from. A Key is a piece
   * of information in a KeyList which defines how values are animated over time.
   */
  class MGENEXPORT MKey : public MDAGNode {
  public:
    /**
     * This sets the time that the Key occurs at.
     * 
     * @param time The new time 
     */
    virtual void setKeyTime(int time) = 0;

    /**
     * This gets the time that the Key occurs at
     *
     * @return the time of the key
     */
    virtual long getKeyTime() = 0;

    /**
     * This gets the index of the key in its Key List
     * 
     * @return The index of the key in its key list.
     */
    virtual int getIndex() = 0;

    /**
     * This gets the KeyList that the key belongs to.
     *
     * @return The Key List that the key belongs to.
     */
    virtual MKeyListPtr getKeyList() = 0;

    /**
     * Is is key selected?
     *
     * @return True if the key is selected, false if it isn't.
     */
    virtual bool isSelected() = 0;

    /**
     * Set this key to be selected or not.
     *
     * @param selected True if the key should be selected, false if 
     *                 it shouldn't.
     */
    virtual void setSelected(bool selected) = 0;
  };
  

}

#endif 
