#ifndef MFloatKeyableValue_Header 
#define MFloatKeyableValue_Header

#include "ModelGeneric.h"

namespace Aztec {

  class MFloatKeyableValue;
  typedef MRefCountedPtr<MFloatKeyableValue> MFloatKeyableValuePtr;

}

#include "MFloatValue.h"
#include "MKeyableValue.h"

namespace Aztec {

  /**
   * This is an interface class for a list of Keys. Each type
   * of key list implements this interface.
   */
  class MGENEXPORT MFloatKeyableValue : public MFloatValue,
                                        public MKeyableValue {
  public:
    /**
     * This sets the initial value of the vector that is used when
     * there are no keys set.
     *
     * @param value The value to use as the initial value.
     */
    virtual void setInitialValue(float value) = 0;

    /**
     * This sets a key at the given time, overwriting any key that is 
     * already present at that time.
     *
     * @param value The Value to be set at the given time. 
     * @param time The time to set the key at
     */
    virtual void setKey(float value, long time) = 0;

  };
  

}

#endif 
