#ifndef MClusterModifier_Header
#define MClusterModifier_Header

#include "ModelGeneric.h"


namespace Aztec {

  class MClusterModifier;
  typedef MRefCountedPtr<MClusterModifier> MClusterModifierPtr;
}

#include <mesh/MMeshModifier.h>
#include <MEditableMesh.h>
#include <params/MMatrix4Parameter.h>

namespace Aztec {


  //---------------------
  //  MClusterModifier
  //---------------------
  
#define CLUSTERFLAG_ACTIVE       0x01
#define CLUSTERFLAG_SELECTED     0x02
  
  // The cluster modifier deals with moving vertices of meshes in weighted groups.
  class MGENEXPORT MClusterModifier : public MMeshModifier {
  public:
    MClusterModifier();
    ~MClusterModifier();

    // cluster Modifier Specific
    /**
     * This sets which Scene object is controlling the cluster.
     */
    void setControllingObject(MSceneObjectPtr Obj);
    /**
     * This gets what Scene Object is controlling the cluster
     */
    MSceneObjectPtr getControllingObject();

    /**
     * This gets the number of points in the cluster.
     */
    int getNumPoints();

    bool isPointSelected(int index);

    void setPointWeight(int index, float weight);

    // Selects the given component number and the given mode.
    int selectComponent(AztecFlags Mode, int CompNum, bool TargetSel);
    bool hasComponentsSelected(AztecFlags Comp);
   
    int modifyObject(MSceneObjectPtr contextObject);
    int drawObject(const MBaseObjectPtr &baseObj, MSceneViewFlags ViewFlags);
    
    // MBaseObject Objects
    MStr getClassName() {return MStr("MClusterModifier");};
    MStr getParentClassName() {return MStr("MModifier");};
    MBaseObjectPtr createNew();
    void setFrom(MBaseObjectPtr SrcObj);
    bool doUpdateObject();

  protected:
    class PointPair {
    public:
      PointPair() 
        : pointIndex(-1),
          selected(false),
          pointWeight(1.0)
      {
      }

      PointPair(int index, float weight) 
        : pointIndex(index), 
          selected(false),
          pointWeight(weight)
      {
      }

      PointPair(const PointPair &src) 
        : pointIndex(src.pointIndex), 
          selected(src.selected),
          pointWeight(src.pointWeight)
      {

      }

      int pointIndex  :31;
      bool selected   :1;
      float pointWeight;
    };

    std::vector<PointPair> activePoints;
    
    MObjectParameterPtr lastInputShapeParam;
    MMeshShapePtr lastInputShape;
    MObjectParameterPtr m_ControlParam;
    MEditableMeshPtr outputMesh;
    
    MMatrix4ParameterPtr m_InitialXFormInv;
//    Matrix4  m_InitialXForm;
    MVector3 m_PivotPoint;
    bool m_PivotSet;

    MObjectParameterPtr lastControlObject;

    void cleanPoints();
    int modifyObject();
    bool checkInputObject();

    friend class ClusterArrayParam;
  };
  
}

#endif
