#ifndef MBONE_H
#define MBONE_H

#include "ModelGeneric.h"

namespace Aztec {
  class MBoneObject;
  
  typedef MRefCountedPtr<MBoneObject> MBoneObjectPtr;
}

#include "MBaseObject.h"
#include "MShapeObject.h"

namespace Aztec {

  //----------------------------------------------------------------------------------------
  //  MBoneObject
  //----------------------------------------------------------------------------------------
  class MGENEXPORT MBoneObject : public MShapeObject {
  protected:
    
  public:
    // Construction/Destruction
    MBoneObject();
    virtual ~MBoneObject();
    
    // Class related
    virtual MStr getClassName() {return MStr("MBoneObject");};
    virtual MStr getParentClassName() {return MStr("MSceneObject");};
    virtual MBaseObjectPtr createNew();
    
    // Draws the object using open gl commands
    virtual bool drawObject(const MBaseObjectPtr &baseObj, MSceneViewFlags ViewFlags);
  };
  

}
#endif
