#ifndef MAnimMesh_Header
#define MAnimMesh_Header

#include "ModelGeneric.h"

namespace Aztec {

  class MAnimMesh;

  typedef MRefCountedPtr<MAnimMesh> MAnimMeshPtr;
}

#include "MEditableMesh.h"

#include <MVector3KeyList.h>

#include <vector>
#include <set>

namespace Aztec {
  //------------------
  //  MAnimatedVertex
  //------------------
  class MGENEXPORT MAnimatedVertex {
  public:
    MVector3KeyListPtr  m_Pos;
    
    MAnimatedVertex();
    virtual ~MAnimatedVertex();
    
    void set(int Time, float x, float y, float z);
    void set(int Time, const MVector3 &V);
    
    void get(int Time, float &x, float &y, float &z);
    void get(int Time, MVector3 &V);
    
  };

  //------------------
  //  MAnimMesh
  //------------------
  class MGENEXPORT MAnimMesh : public MEditableMesh {
  protected:
    std::vector<MAnimatedVertex*> m_AnimVerts;   

    void updatePointAnimation(int index, long time, bool createKey);
    
  public:
    MAnimMesh();
    virtual ~MAnimMesh();
    
    virtual MStr getClassName() {return MStr("MAnimMesh");};
    virtual MStr getParentClassName() {return MStr("MEditableMesh");};
    virtual MBaseObjectPtr createNew();
    void setFrom(MBaseObjectPtr SrcObj);
    
    virtual int addVertex(float x, float y, float z);
    virtual int addVertexArray(const MVector3 Vert[], int Num = 1);
    virtual void deleteVertex(int Num);
    virtual void deleteVertexArray(const int *VertNums, int Num = 1);
    
    void updateMesh();
    void updateKey(long Time, bool Animate = true);
    
    // Sets the values of the array of vertices at the current time
    virtual void setVertexArray(MVector3 *Vert, int Num = 1, int StartNum = 0);
    // Sets the values of the array of vertices at the given time
    virtual void setVertexArray(long time, MVector3 *Vert, int Num = 1, int StartNum = 0);
    
    MAnimatedVertex* getAnimVert(int Num);
    virtual int collapseVertices(VERTFLAGS Flags);
    
    // MComponentisedObject methods
    void updateComponentAnimation(AztecFlags type, AztecFlags flag, long time, bool createKey);
    void updateSingleComponentAnimation(AztecFlags type, int index, long time, bool createKey);

    // MBaseObject methods
    bool doUpdateObject();
  };
  
}
#endif
