#include <AztecGUICommonPCH.h>
#include <gui/MMessageDialog.h>

namespace Aztec {
  MMessageDialog::MMessageDialog() {
  }

  MMessageDialog::Buttons MMessageDialog::doModal(const MComponentPtr &owner, const std::string &caption, const std::string &body, int buttons) {

    UINT type = MB_OK;

    if ((buttons & YES) && (buttons & NO) && (buttons & CANCEL)) {
      type = MB_YESNOCANCEL;
    } else if ((buttons & OK) && (buttons & CANCEL)) {
      type = MB_OKCANCEL;
    } else if ((buttons & YES) && (buttons & NO)) {
      type = MB_YESNO;
    } else if (buttons & OK) {
      type = MB_OK;
    } else {
      type = MB_OK;
    }

    int result = ::MessageBox(owner != NULL ? owner->getHWnd() : NULL, body.c_str(), caption.c_str(), type);

    switch (result) {
    case IDOK: return OK;
    case IDCANCEL: return CANCEL;
    case IDYES: return YES;
    case IDNO: return NO;
    default: return OK;
    }
  }



}

