#include <AztecGUICommonPCH.h>

#include <gui/win32/MLabelImpl.h>
#include <gui/win32/MAppImpl.h>

#include <assert.h>

#if defined( _DEBUG ) && defined( _MSC_VER )
// Memory leak detection for MS compiler
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


namespace Aztec {

  MLabel::MLabel(const std::string &label)
    : MComponent(), minSize(-1,-1)
  {
    m_Value = label;
  }

  MLabel::~MLabel() {
  }

  void MLabel::setInternalValue(const std::string &value) {
    m_Value = value;
  }

  bool MLabel::createImpl() {
    MApp *app;
    HWND parentHWND = NULL;

    if (m_Parent != NULL) {
      parentHWND = m_Parent->getHWnd();
    }

    app = MApp::getInstance();

    m_hWnd = ::CreateWindow("STATIC", m_Value.c_str(), WS_CHILD | SS_WORDELLIPSIS,
                            0, 10, 0, 10, parentHWND, NULL, app->getHInstance(), NULL);

    if (m_hWnd != 0) {
      // now subclass us
      app->registerComponent(m_hWnd, this);

      ::SendMessage(m_hWnd, WM_SETFONT, (DWORD)::GetStockObject(DEFAULT_GUI_FONT), 0);

      onCreate();

      setVisible(true);
      ::UpdateWindow(m_hWnd);

      return true;
    }

    return false;
  }

  void MLabel::setValue(const std::string &value) {
    if (value == m_Value) {
      return;
    }

    // reset the size calculations so for the call to getMinimumSize().
    minSize.setHeight(-1);
    minSize.setWidth(-1);

    m_Value = value;
    if (m_hWnd != NULL) {
      ::SetWindowText(m_hWnd, value.c_str());
    }
  }

  std::string MLabel::getValue() {
    return m_Value;
  }

  bool MLabel::onChanged() {
    return false;
  }

  bool MLabel::isMinimumSizeSet() {
    return true;
  }

  MSize2D MLabel::getMinimumSize() {
    // get the size of our font
    if (minSize.getWidth() < 0 || minSize.getHeight() < 0) {
      HDC dc = ::GetDC(m_hWnd);      

      HFONT editFont = (HFONT)::SendMessage(m_hWnd, WM_GETFONT, 0, 0);

      if (editFont != NULL) {
        ::SelectObject(dc, editFont);
      }

      SIZE textSize;
      BOOL result =   ::GetTextExtentPoint(dc, m_Value.c_str(), m_Value.size(), &textSize);

      if (result != FALSE) {
        if (minSize.getHeight() < 0) {
          minSize.setHeight(textSize.cy);
        }

        if (minSize.getWidth() < 0) {
          minSize.setWidth(textSize.cx);
        }
      } else {
        DWORD error = ::GetLastError();
        printf("Error MLabel::getMinimumSize() - ::GetTextExtentPoint() error = '%i'\n", error);
      }

      ::ReleaseDC(m_hWnd, dc);
    }

    return MSize2D::getLargest(minSize, MComponent::getMinimumSize());
  
  }


}

