#include <AztecGUICommonPCH.h>
#include <gui/MGLCanvas.h>

#include <gui/win32/MAppImpl.h>
#include <gui/win32/MGLCanvasImpl.h>

#include <MSystemManager.h>

#define WGL_OK                      0
#define WGL_CREATECONTEXT_FAILED      1
#define WGL_MAKECURRENT_FAILED        2

#if defined( _DEBUG ) && defined( _MSC_VER )
// Memory leak detection for MS compiler
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


namespace Aztec {

  MGLCanvas::MGLCanvas() {
    glContext = NULL;
    sizeChanged = false;
  }

  MGLCanvas::~MGLCanvas() {
    killOpenGL();
  }

  MGLCanvas::GLErrorEnum MGLCanvas::initOpenGL() {
    PIXELFORMATDESCRIPTOR pfd = {
      sizeof(PIXELFORMATDESCRIPTOR),// size of this pfd
        1,                     // version number 
        PFD_DRAW_TO_WINDOW |   // support window 
        PFD_SUPPORT_OPENGL |   // support OpenGL 
        PFD_DOUBLEBUFFER,      // double buffered 
        PFD_TYPE_RGBA,         // RGBA type 
        16,                    // bit color depth 
        0, 0, 0, 0, 0, 0,      // color bits ignored 
        0,                     // no alpha buffer 
        0,                     // shift bit ignored 
        0,                     // no accumulation buffer 
        0, 0, 0, 0,            // accum bits ignored 
        16,                    // z-buffer 
        0,                     // no stencil buffer 
        0,                     // no auxiliary buffer 
        PFD_MAIN_PLANE,        // main layer 
        0,                     // reserved 
        0, 0, 0                // layer masks ignored 
    }; 
    int  iPixelFormat;
    
    HDC hDC = ::GetDC(m_hWnd);
    
    // get the best available match of pixel format for the device context  
    iPixelFormat = ChoosePixelFormat(hDC, &pfd); 
    
    // make that the pixel format of the device context 
    MSystemManager::getInstance()->logOutput("OpenGLWnd::InitOpenGL() - Pixel Format %ibpp, %iAlpha bits, %iZBuf", pfd.cColorBits, pfd.cAlphaBits, pfd.cDepthBits);
    SetPixelFormat(hDC, iPixelFormat, &pfd); 	
    
    
    // since the pixel format has been set, we can create the opengl rendering context
    // and set it as active.
    
    glContext = wglCreateContext(hDC);
    
    ::ReleaseDC(m_hWnd, hDC);
    
    if (glContext == NULL) {
      MSystemManager::getInstance()->logOutput("OpenGLWnd::InitOpenGL() - context Creation failed!");
      return GL_CREATECONTEXT_FAILED;
    }
    
    if (makeCurrent() == GL_MAKECURRENT_FAILED) {
      MSystemManager::getInstance()->logOutput("OpenGLWnd::InitOpenGL() - Make current failed!");
      return GL_MAKECURRENT_FAILED;
    }
    
    // put in some dummy values
    glViewport(0,0,900,900);
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    float m_Aspect = 1;
    glMatrixMode(GL_MODELVIEW);
    
    glShadeModel(GL_SMOOTH);
    
    glEnable(GL_DEPTH_TEST);
    glEnable(GL_CULL_FACE);
    glEnable(GL_NORMALIZE);
    glCullFace(GL_BACK);
    
    glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);
    
    glShadeModel(GL_SMOOTH);
    glEnable(GL_LIGHT0);

    return GL_OK;
  }

  MGLCanvas::GLErrorEnum MGLCanvas::killOpenGL() {
    // Make the current context not null.
    wglMakeCurrent(NULL, NULL);
    wglDeleteContext(glContext);
    glContext = NULL;
    
    return GL_OK;
  }


  // IMGLCanvas methods
  MGLCanvas::GLErrorEnum MGLCanvas::makeCurrent() {
    return makeCurrent(this->paintDC);
  }

  bool MGLCanvas::swapBuffers() {
    return swapBuffers(this->paintDC);
  }

  bool MGLCanvas::createImpl() {
    bool result = MComponent::createImpl();

    initOpenGL();

    return result;
  }

  MGLCanvas::GLErrorEnum MGLCanvas::makeCurrent(HDC dc) {
    HGLRC CurrentContext;
    int result = 0;
    bool needToRelease = false;
    
    CurrentContext = wglGetCurrentContext();
    
    if (CurrentContext != glContext) {
      if (dc == NULL) {
        dc = ::GetDC(m_hWnd);
        needToRelease = true;
      }
    
      if (wglMakeCurrent(dc, glContext) == FALSE) {
        result = GL_MAKECURRENT_FAILED;
      } else {
        // this is here to avoid calling glViewport during a resize call. If 
        // glViewport was called there, then glMakeCurrent woudl need to be 
        //called, thus creating and destroying a DC, which is unnecessary 
        // when it could just be done here.
        if (sizeChanged) {
          glViewport(0,0,newx, newy);
          sizeChanged = false;
        }
      }
    } else {
      // this is here to avoid calling glViewport during a resize call. If 
      // glViewport was called there, then glMakeCurrent woudl need to be 
      //called, thus creating and destroying a DC, which is unnecessary 
      // when it could just be done here.
      if (sizeChanged) {
        glViewport(0,0,newx, newy);
        sizeChanged = false;
      }
    }
    
    if (needToRelease) {
      ::ReleaseDC(m_hWnd, dc);
    }  

    return GL_OK;
  }

  bool MGLCanvas::swapBuffers(HDC dc) {
    bool needToRelease = false;
    int result;
    
    if (dc == NULL) {
      dc = ::GetDC(m_hWnd);
      needToRelease = true;
    }
    
    result = SwapBuffers(dc);
    
    if (needToRelease) {
      ::ReleaseDC(m_hWnd, dc);
    }
    
    return result != FALSE;
    
  }

  bool MGLCanvas::onResize(int newWidth, int newHeight) {
    sizeChanged = true;
    newx = newWidth;
    newy = newHeight;
    MComponent::onResize(newWidth, newHeight);

    return true;
  }

  bool MGLCanvas::onPaint() {
    bool result = MComponent::onPaint();

    makeCurrent(paintDC);

    /*
    glClearColor(0.4,0.3,0.3,1.0);
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

    glBegin(GL_TRIANGLES);
    glVertex3f(-1,0,0);
    glVertex3f(0.1,0.1,0.1);
    glVertex3f(-0.1,-0.1,-0.1);
    glEnd();

    
    glFlush();

    swapBuffers();*/


    return true;

  }

}
