#include <AztecGUICommonPCH.h>

#include <gui/win32/MCheckboxImpl.h>
#include <gui/win32/MAppImpl.h>

#include <assert.h>

#if defined( _DEBUG ) && defined( _MSC_VER )
// Memory leak detection for MS compiler
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


namespace Aztec {

  MCheckbox::MCheckbox(bool value)
    : MComponent(), minSize(-1,-1)
  {
    startValue = value;
  }

  MCheckbox::~MCheckbox() {
  }

  bool MCheckbox::createImpl() {
    MApp *app;
    HWND parentHWND = NULL;

    if (m_Parent != NULL) {
      parentHWND = m_Parent->getHWnd();
    }

    app = MApp::getInstance();

    m_hWnd = CreateWindowEx(0, "BUTTON", "", WS_CHILD | BS_CHECKBOX  | WS_TABSTOP, 
                            0, 10, 0, 10, parentHWND, NULL, app->getHInstance(), NULL); 
    
    if (m_hWnd != 0) {
      // now subclass us
      app->registerComponent(m_hWnd, this);

      ::SendMessage(m_hWnd, WM_SETFONT, (DWORD)::GetStockObject(DEFAULT_GUI_FONT), 0);

      ::SendMessage(m_hWnd, BM_SETCHECK, startValue ? BST_CHECKED : BST_UNCHECKED, 0);

      onCreate();

      setVisible(true);
      ::UpdateWindow(m_hWnd);

      return true;
    }

    return false;
  }

  bool MCheckbox::wndProc(UINT message, WPARAM wParam, LPARAM lParam, LRESULT *result) {
    if (message == WM_COMMAND) {
      WORD wNotifyCode = HIWORD(wParam); // notification code 
      WORD wID = LOWORD(wParam);         // item, control, or accelerator identifier 
      HWND hwndCtl = (HWND) lParam;      // handle of control 

      if (wNotifyCode == BN_CLICKED) {
        ::SendMessage(hwndCtl, BM_SETCHECK, getValue() ? BST_UNCHECKED : BST_CHECKED, 0);
        onChanged();
        for (std::vector<ChangeListenerPtr>::iterator i = listeners.begin(); i != listeners.end(); ++i) {
          (*i)->onChange(this);
        }
      }
    }

    return MComponent::wndProc(message, wParam, lParam, result);
  }

  void MCheckbox::setValue(bool value) {
    startValue = value;
    ::SendMessage(m_hWnd, BM_SETCHECK, value ? BST_CHECKED : BST_UNCHECKED, 0);
  }

  bool MCheckbox::getValue() {
    return ::SendMessage(m_hWnd, BM_GETCHECK, 0, 0) == BST_CHECKED;
  }

  bool MCheckbox::onChanged() {
    return false;
  }

  void MCheckbox::addListener(const ChangeListenerPtr &listener) {
    listeners.push_back(listener);
  }

  bool MCheckbox::isMinimumSizeSet() {
    return true;
  }

  MSize2D MCheckbox::getMinimumSize() {
    return MSize2D(12,12);
  }


}

