#include <AztecGUICommonPCH.h>

#include <gui/scripting/AztecGUIScripting.h>
#include <gui/MToolWindow.h>

namespace Aztec {


  JSBool js_MToolWindow_constructor(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval) {
    
    std::string title = "Window";

    if (argc >= 1) {
      title = JS_GetStringBytes(JS_ValueToString(cx, argv[0]));
    }

    MToolWindowPtr newComponent = new MToolWindow(title, NULL);
    newComponent->create();
    
    return JS_SetPrivate(cx, obj, new JS_GUIObject(newComponent));
  }

  static JSPropertySpec js_MToolWindow_props[] = {
    {0, 0, 0, 0}
  };
 
  
  JSClass js_MToolWindow_class = {
    "MToolWindow", JSCLASS_HAS_PRIVATE,
      JS_PropertyStub, JS_PropertyStub,
      JS_PropertyStub, JS_PropertyStub,
      JS_EnumerateStub, JS_ResolveStub,
      JS_ConvertStub,   JS_FinalizeStub
  };
  
  JSFunctionSpec aztecMToolWindow_methods[] = {
    {NULL,                NULL,                   0} 
  };
  
  JSObject* initMToolWindowClass(JSContext *cx, JSObject *windowClass) {
    JSObject *cl = JS_InitClass(cx, JS_GetGlobalObject(cx), windowClass,
      &js_MToolWindow_class, js_MToolWindow_constructor, 0,
      NULL, aztecMToolWindow_methods, 0, 0);
    
    JS_DefineProperties(cx, cl, js_MToolWindow_props);

    return cl;
    
  }
}
