#include <AztecGUICommonPCH.h>

#include <gui/scripting/AztecGUIScripting.h>
#include <gui/MGridLayout.h>

namespace Aztec {
  JSBool js_MGridLayout_constructor(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval) {
    // we only accept 0, or 2 arguments to a constructor.
    // with zero, args, we do a default border width. 2 args we have a border width and height.
    if (argc != 2) {
      JS_ReportError(cx, "MGridLayout constructor requires 2 arguments, only got %i", argc);
      return JS_FALSE;
    }

    int32 columns, rows;
    if (!JS_ValueToInt32(cx, argv[0], &columns)) {
      JS_ReportError(cx, "Error argument 0 is not an integer");
      return JS_FALSE;
    }
    if (!JS_ValueToInt32(cx, argv[1], &rows)) {
      JS_ReportError(cx, "Error argument 1 is not an integer");
      return JS_FALSE;
    }

    MLayoutManagerPtr layout;
    
    layout = new MGridLayout(columns, rows);
    
    return JS_SetPrivate(cx, obj, new JS_GUIObject(layout));
  }
  
  JSClass js_MGridLayout_class = {
    "MGridLayout", JSCLASS_HAS_PRIVATE,
      JS_PropertyStub, JS_PropertyStub,
      JS_PropertyStub, JS_PropertyStub,
      JS_EnumerateStub, JS_ResolveStub,
      JS_ConvertStub,   JS_FinalizeStub
  };
  
  
  static JSFunctionSpec aztecMGridLayout_methods[] = {
    {NULL,                NULL,                   0} 
  };
  
  JSObject* initMGridLayoutClass(JSContext *cx) {
    JSObject *cl = JS_InitClass(cx, JS_GetGlobalObject(cx), NULL,
      &js_MGridLayout_class, js_MGridLayout_constructor, 0,
      NULL, aztecMGridLayout_methods, 0, 0);
    

    return cl;
  }


}
