#include <AztecGUICommonPCH.h>

#include <gui/scripting/AztecGUIScripting.h>
#include <gui/MContainer.h>
namespace Aztec {

  static JSBool js_addComponent(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval);
  static JSBool js_setLayoutManager(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval);

  JSBool js_MContainer_constructor(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval) {
    return js_generic_constructor(cx, obj, new MContainer());
  }

  JSClass js_MContainer_class = {
    "MContainer", JSCLASS_HAS_PRIVATE,
      JS_PropertyStub, JS_PropertyStub,
      JS_PropertyStub, JS_PropertyStub,
      JS_EnumerateStub, JS_ResolveStub,
      JS_ConvertStub,   JS_FinalizeStub
  };
  
  JSFunctionSpec aztecMContainer_methods[] = {
    // Object/mesh creation
    {"addComponent",      js_addComponent,        2},
    {"setLayoutManager",  js_setLayoutManager,    1},
    {NULL,                NULL,                   0} 
  };
  
  JSObject* initMContainerClass(JSContext *cx, JSObject *componentClass) {
    JSObject *cl = JS_InitClass(cx, JS_GetGlobalObject(cx), componentClass,
      &js_MContainer_class, js_MContainer_constructor, 0,
      NULL, aztecMContainer_methods, 0, 0);
    
    return cl;
    
  }
  
  JSObject* getJSObject(JSContext *cx, JSObject *parent, const MContainerPtr &container) {
    JSObject *result = JS_NewObject(cx, &js_MContainer_class, NULL, parent);
    js_generic_constructor(cx, result, &*container);

    return result;
  }
  
  static JSBool js_addComponent(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval)
  {
    if (argc < 1 || argc > 2) {
      return JS_FALSE;
    }
    
    if (!JSVAL_IS_OBJECT(argv[0])) {
      return JS_FALSE;
    }
    
    MComponentPtr comp = getGuiObject<MComponent>(cx, JSVAL_TO_OBJECT(argv[0]));
    MContainerPtr container = getGuiObject<MContainer>(cx, obj);
    
    if (container != NULL && comp != NULL) {
      if (argc == 2) {
        container->addComponent(comp, MConstraint(JSVAL_TO_INT(argv[1])));
      } else {
        container->addComponent(comp);
      }
      
      return JS_TRUE;
    } else {
      return JS_FALSE;
    }
  }
  
  static JSBool js_setLayoutManager(JSContext *cx, JSObject *obj, uintN argc, jsval *argv, jsval *rval)
  {
    if (argc != 1) {
      return JS_FALSE;
    }
    
    if (!JSVAL_IS_OBJECT(argv[0])) {
      return JS_FALSE;
    }
    
    MLayoutManagerPtr layout = getGuiObject<MLayoutManager>(cx, JSVAL_TO_OBJECT(argv[0]));
    MContainerPtr container = getGuiObject<MContainer>(cx, obj);
    
    if (container != NULL && layout != NULL) {
      container->setLayoutManager(layout);
      return JS_TRUE;
    } else {
      return JS_FALSE;
    }
  }
  
  

}
